/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.filter.tps;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.filter.tps.StatItem;
import kd.bos.krpc.rpc.filter.tps.TPSLimiter;

public class DefaultTPSLimiter
implements TPSLimiter {
    private final ConcurrentMap<String, StatItem> stats = new ConcurrentHashMap<String, StatItem>();

    @Override
    public boolean isAllowable(URL url, Invocation invocation) {
        int rate = url.getParameter("tps", -1);
        long interval = url.getParameter("tps.interval", 60000L);
        String serviceKey = url.getServiceKey();
        if (rate > 0) {
            StatItem statItem = (StatItem)this.stats.get(serviceKey);
            if (statItem == null) {
                this.stats.putIfAbsent(serviceKey, new StatItem(serviceKey, rate, interval));
                statItem = (StatItem)this.stats.get(serviceKey);
            }
            return statItem.isAllowable(url, invocation);
        }
        StatItem statItem = (StatItem)this.stats.get(serviceKey);
        if (statItem != null) {
            this.stats.remove(serviceKey);
        }
        return true;
    }
}

