/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.listener;

import java.util.List;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.ExporterListener;
import kd.bos.krpc.rpc.Invoker;

public class ListenerExporterWrapper<T>
implements Exporter<T> {
    private static final Logger logger = LoggerFactory.getLogger(ListenerExporterWrapper.class);
    private final Exporter<T> exporter;
    private final List<ExporterListener> listeners;

    public ListenerExporterWrapper(Exporter<T> exporter, List<ExporterListener> listeners) {
        if (exporter == null) {
            throw new IllegalArgumentException("exporter == null");
        }
        this.exporter = exporter;
        this.listeners = listeners;
        if (listeners != null && listeners.size() > 0) {
            RuntimeException exception = null;
            for (ExporterListener listener : listeners) {
                if (listener == null) continue;
                try {
                    listener.exported(this);
                }
                catch (RuntimeException t) {
                    logger.error(t.getMessage(), t);
                    exception = t;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    @Override
    public Invoker<T> getInvoker() {
        return this.exporter.getInvoker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unexport() {
        try {
            this.exporter.unexport();
        }
        finally {
            if (this.listeners != null && this.listeners.size() > 0) {
                RuntimeException exception = null;
                for (ExporterListener listener : this.listeners) {
                    if (listener == null) continue;
                    try {
                        listener.unexported(this);
                    }
                    catch (RuntimeException t) {
                        logger.error(t.getMessage(), t);
                        exception = t;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
    }
}

