/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol;

import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.Invoker;

public abstract class AbstractExporter<T>
implements Exporter<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Invoker<T> invoker;
    private volatile boolean unexported = false;

    public AbstractExporter(Invoker<T> invoker) {
        if (invoker == null) {
            throw new IllegalStateException("service invoker == null");
        }
        if (invoker.getInterface() == null) {
            throw new IllegalStateException("service type == null");
        }
        if (invoker.getUrl() == null) {
            throw new IllegalStateException("service url == null");
        }
        this.invoker = invoker;
    }

    @Override
    public Invoker<T> getInvoker() {
        return this.invoker;
    }

    @Override
    public void unexport() {
        if (this.unexported) {
            return;
        }
        this.unexported = true;
        this.getInvoker().destroy();
    }

    public String toString() {
        return this.getInvoker().toString();
    }
}

