/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.ConcurrentHashSet;
import kd.bos.krpc.common.utils.ConfigUtils;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Protocol;
import kd.bos.krpc.rpc.support.ProtocolUtils;

public abstract class AbstractProtocol
implements Protocol {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, Exporter<?>> exporterMap = new ConcurrentHashMap();
    protected final Set<Invoker<?>> invokers = new ConcurrentHashSet();

    protected static String serviceKey(URL url) {
        return ProtocolUtils.serviceKey(url);
    }

    protected static String serviceKey(int port, String serviceName, String serviceVersion, String serviceGroup) {
        return ProtocolUtils.serviceKey(port, serviceName, serviceVersion, serviceGroup);
    }

    @Override
    public void destroy() {
        for (Invoker<?> invoker : this.invokers) {
            if (invoker == null) continue;
            this.invokers.remove(invoker);
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Destroy reference: " + invoker.getUrl());
                }
                invoker.destroy();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
        for (String key : new ArrayList<String>(this.exporterMap.keySet())) {
            Exporter<?> exporter = this.exporterMap.remove(key);
            if (exporter == null) continue;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Unexport service: " + exporter.getInvoker().getUrl());
                }
                exporter.unexport();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
    }

    protected static int getServerShutdownTimeout() {
        int timeout = 10000;
        String value = ConfigUtils.getProperty("dubbo.service.shutdown.wait");
        if (value != null && value.length() > 0) {
            try {
                timeout = Integer.parseInt(value);
            }
            catch (Exception exception) {}
        } else {
            value = ConfigUtils.getProperty("dubbo.service.shutdown.wait.seconds");
            if (value != null && value.length() > 0) {
                try {
                    timeout = Integer.parseInt(value) * 1000;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return timeout;
    }
}

