/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol;

import java.util.Collections;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.ExporterListener;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.InvokerListener;
import kd.bos.krpc.rpc.Protocol;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.listener.ListenerExporterWrapper;
import kd.bos.krpc.rpc.listener.ListenerInvokerWrapper;

public class ProtocolListenerWrapper
implements Protocol {
    private final Protocol protocol;

    public ProtocolListenerWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        if ("registry".equals(invoker.getUrl().getProtocol())) {
            return this.protocol.export(invoker);
        }
        return new ListenerExporterWrapper<T>(this.protocol.export(invoker), Collections.unmodifiableList(ExtensionLoader.getExtensionLoader(ExporterListener.class).getActivateExtension(invoker.getUrl(), "exporter.listener")));
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        if ("registry".equals(url.getProtocol())) {
            return this.protocol.refer(type, url);
        }
        return new ListenerInvokerWrapper<T>(this.protocol.refer(type, url), Collections.unmodifiableList(ExtensionLoader.getExtensionLoader(InvokerListener.class).getActivateExtension(url, "invoker.listener")));
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }
}

