/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.dubbo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.serialize.Cleanable;
import kd.bos.krpc.common.serialize.ObjectInput;
import kd.bos.krpc.common.utils.Assert;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.Codec;
import kd.bos.krpc.remoting.Decodeable;
import kd.bos.krpc.remoting.exchange.Response;
import kd.bos.krpc.remoting.transport.CodecSupport;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.RpcResult;
import kd.bos.krpc.rpc.Tracer;
import kd.bos.krpc.rpc.support.RpcUtils;

public class DecodeableRpcResult
extends RpcResult
implements Codec,
Decodeable,
Tracer {
    private static final Logger log = LoggerFactory.getLogger(DecodeableRpcResult.class);
    private Channel channel;
    private byte serializationType;
    private InputStream inputStream;
    private Response response;
    private Invocation invocation;
    private volatile boolean hasDecoded;
    private Object tracer;

    public DecodeableRpcResult(Channel channel, Response response, InputStream is, Invocation invocation, byte id) {
        Assert.notNull(channel, "channel == null");
        Assert.notNull(response, "response == null");
        Assert.notNull(is, "inputStream == null");
        this.channel = channel;
        this.response = response;
        this.inputStream = is;
        this.invocation = invocation;
        this.serializationType = id;
    }

    @Override
    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(Channel channel, InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerialization(channel.getUrl(), this.serializationType).deserialize(channel.getUrl(), input);
        try {
            byte flag = in.readByte();
            switch (flag) {
                case 2: {
                    try {
                        this.setTracer(in.readObject());
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(StringUtils.toString("Read response data failed.", e));
                    }
                }
                case 1: {
                    try {
                        Type[] returnType = RpcUtils.getReturnTypes(this.invocation);
                        this.setValue(returnType == null || returnType.length == 0 ? in.readObject() : (returnType.length == 1 ? in.readObject((Class)returnType[0]) : in.readObject((Class)returnType[0], returnType[1])));
                        this.setTracer(in.readObject());
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(StringUtils.toString("Read response data failed.", e));
                    }
                }
                case 0: {
                    try {
                        Object obj = in.readObject();
                        if (!(obj instanceof Throwable)) {
                            throw new IOException("Response data error, expect Throwable, but get " + obj);
                        }
                        this.setException((Throwable)obj);
                        this.setTracer(in.readObject());
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(StringUtils.toString("Read response data failed.", e));
                    }
                }
                default: {
                    throw new IOException("Unknown result flag, expect '0' '1' '2', get " + flag);
                }
            }
            DecodeableRpcResult decodeableRpcResult = this;
            return decodeableRpcResult;
        }
        finally {
            if (in instanceof Cleanable) {
                ((Cleanable)((Object)in)).cleanup();
            }
        }
    }

    @Override
    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode rpc result failed: " + e.getMessage(), e);
                }
                this.response.setStatus((byte)90);
                this.response.setErrorMessage(StringUtils.toString(e));
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    @Override
    public Object getTracer() {
        return this.tracer;
    }

    @Override
    public void setTracer(Object tracer) {
        this.tracer = tracer;
    }
}

