/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.dubbo;

import java.io.IOException;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.Codec2;
import kd.bos.krpc.remoting.buffer.ChannelBuffer;
import kd.bos.krpc.remoting.exchange.Request;
import kd.bos.krpc.remoting.exchange.Response;
import kd.bos.krpc.remoting.exchange.support.MultiMessage;
import kd.bos.krpc.rpc.RpcInvocation;
import kd.bos.krpc.rpc.RpcResult;
import kd.bos.krpc.rpc.protocol.dubbo.DubboCodec;

public final class DubboCountCodec
implements Codec2 {
    private DubboCodec codec = new DubboCodec();

    @Override
    public void encode(Channel channel, ChannelBuffer buffer, Object msg) throws IOException {
        this.codec.encode(channel, buffer, msg);
    }

    @Override
    public Object decode(Channel channel, ChannelBuffer buffer) throws IOException {
        int save = buffer.readerIndex();
        MultiMessage result = MultiMessage.create();
        while (true) {
            Object obj;
            if (Codec2.DecodeResult.NEED_MORE_INPUT == (obj = this.codec.decode(channel, buffer))) break;
            result.addMessage(obj);
            this.logMessageLength(obj, buffer.readerIndex() - save);
            save = buffer.readerIndex();
        }
        buffer.readerIndex(save);
        if (result.isEmpty()) {
            return Codec2.DecodeResult.NEED_MORE_INPUT;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    private void logMessageLength(Object result, int bytes) {
        if (bytes <= 0) {
            return;
        }
        if (result instanceof Request) {
            try {
                ((RpcInvocation)((Request)result).getData()).setAttachment("input", String.valueOf(bytes));
            }
            catch (Throwable throwable) {}
        } else if (result instanceof Response) {
            try {
                ((RpcResult)((Response)result).getResult()).setAttachment("output", String.valueOf(bytes));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

