/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.dubbo;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.remoting.RemotingException;
import kd.bos.krpc.remoting.TimeoutException;
import kd.bos.krpc.remoting.exchange.ResponseFuture;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;

public class FutureAdapter<V>
implements Future<V> {
    private final ResponseFuture future;

    public FutureAdapter(ResponseFuture future) {
        this.future = future;
    }

    public ResponseFuture getFuture() {
        return this.future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return (V)((Result)this.future.get()).recreate();
        }
        catch (RemotingException e) {
            throw new ExecutionException(e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new RpcException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
        int timeoutInMillis = (int)unit.convert(timeout, TimeUnit.MILLISECONDS);
        try {
            return (V)((Result)this.future.get(timeoutInMillis)).recreate();
        }
        catch (TimeoutException e) {
            throw new java.util.concurrent.TimeoutException(StringUtils.toString(e));
        }
        catch (RemotingException e) {
            throw new ExecutionException(e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new RpcException(e);
        }
    }
}

