/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.dubbo.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.utils.NetUtils;
import kd.bos.krpc.container.page.Menu;
import kd.bos.krpc.container.page.Page;
import kd.bos.krpc.container.page.PageHandler;
import kd.bos.krpc.remoting.exchange.ExchangeServer;
import kd.bos.krpc.rpc.protocol.dubbo.DubboProtocol;

@Menu(name="Servers", desc="Show exported service servers.", order=14000)
public class ServersPageHandler
implements PageHandler {
    @Override
    public Page handle(URL url) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        Collection<ExchangeServer> servers = DubboProtocol.getDubboProtocol().getServers();
        int clientCount = 0;
        if (servers != null && servers.size() > 0) {
            for (ExchangeServer s : servers) {
                ArrayList<String> row = new ArrayList<String>();
                String address = s.getUrl().getAddress();
                row.add(NetUtils.getHostName(address) + "/" + address);
                int clientSize = s.getExchangeChannels().size();
                clientCount += clientSize;
                row.add("<a href=\"clients.html?port=" + s.getUrl().getPort() + "\">Clients(" + clientSize + ")</a>");
                rows.add(row);
            }
        }
        return new Page("Servers", "Servers (" + rows.size() + ")", new String[]{"Server Address:", "Clients(" + clientCount + ")"}, rows);
    }
}

