/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.dubbo.status;

import java.util.Collection;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.status.Status;
import kd.bos.krpc.common.status.StatusChecker;
import kd.bos.krpc.remoting.exchange.ExchangeServer;
import kd.bos.krpc.rpc.protocol.dubbo.DubboProtocol;

@Activate
public class ServerStatusChecker
implements StatusChecker {
    @Override
    public Status check() {
        Collection<ExchangeServer> servers = DubboProtocol.getDubboProtocol().getServers();
        if (servers == null || servers.size() == 0) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = Status.Level.OK;
        StringBuilder buf = new StringBuilder();
        for (ExchangeServer server : servers) {
            if (!server.isBound()) {
                level = Status.Level.ERROR;
                buf.setLength(0);
                buf.append(server.getLocalAddress());
                break;
            }
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(server.getLocalAddress());
            buf.append("(clients:");
            buf.append(server.getChannels().size());
            buf.append(")");
        }
        return new Status(level, buf.toString());
    }
}

