/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.dubbo.telnet;

import java.util.Collection;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.exchange.ExchangeChannel;
import kd.bos.krpc.remoting.exchange.ExchangeServer;
import kd.bos.krpc.remoting.telnet.TelnetHandler;
import kd.bos.krpc.remoting.telnet.support.Help;
import kd.bos.krpc.rpc.protocol.dubbo.DubboProtocol;

@Activate
@Help(parameter="[-l] [port]", summary="Print server ports and connections.", detail="Print server ports and connections.")
public class PortTelnetHandler
implements TelnetHandler {
    @Override
    public String telnet(Channel channel, String message) {
        StringBuilder buf = new StringBuilder();
        String port = null;
        boolean detail = false;
        if (message.length() > 0) {
            String[] parts = message.split("\\s+");
            for (String part : parts) {
                if ("-l".equals(part)) {
                    detail = true;
                    continue;
                }
                if (!StringUtils.isInteger(part)) {
                    return "Illegal port " + part + ", must be integer.";
                }
                port = part;
            }
        }
        if (port == null || port.length() == 0) {
            for (ExchangeServer server : DubboProtocol.getDubboProtocol().getServers()) {
                if (buf.length() > 0) {
                    buf.append("\r\n");
                }
                if (detail) {
                    buf.append(server.getUrl().getProtocol() + "://" + server.getUrl().getAddress());
                    continue;
                }
                buf.append(server.getUrl().getPort());
            }
        } else {
            ExchangeServer server;
            int p = Integer.parseInt(port);
            server = null;
            for (ExchangeServer s : DubboProtocol.getDubboProtocol().getServers()) {
                if (p != s.getUrl().getPort()) continue;
                server = s;
                break;
            }
            if (server != null) {
                Collection<ExchangeChannel> channels = server.getExchangeChannels();
                for (ExchangeChannel c : channels) {
                    if (buf.length() > 0) {
                        buf.append("\r\n");
                    }
                    if (detail) {
                        buf.append(c.getRemoteAddress() + " -> " + c.getLocalAddress());
                        continue;
                    }
                    buf.append(c.getRemoteAddress());
                }
            } else {
                buf.append("No such port " + port);
            }
        }
        return buf.toString();
    }
}

