/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.dubbo.telnet;

import java.lang.reflect.Method;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.telnet.TelnetHandler;
import kd.bos.krpc.remoting.telnet.support.Help;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.protocol.dubbo.DubboProtocol;
import kd.bos.krpc.rpc.protocol.dubbo.filter.TraceFilter;

@Activate
@Help(parameter="[service] [method] [times]", summary="Trace the service.", detail="Trace the service.")
public class TraceTelnetHandler
implements TelnetHandler {
    @Override
    public String telnet(Channel channel, String message) {
        String times;
        String method;
        String service = (String)channel.getAttribute("telnet.service");
        if (!(service != null && service.length() != 0 || message != null && message.length() != 0)) {
            return "Please input service name, eg: \r\ntrace XxxService\r\ntrace XxxService xxxMethod\r\ntrace XxxService xxxMethod 10\r\nor \"cd XxxService\" firstly.";
        }
        String[] parts = message.split("\\s+");
        if (service == null || service.length() == 0) {
            service = parts.length > 0 ? parts[0] : null;
            method = parts.length > 1 ? parts[1] : null;
        } else {
            String string = method = parts.length > 0 ? parts[0] : null;
        }
        if (StringUtils.isInteger(method)) {
            times = method;
            method = null;
        } else {
            String string = times = parts.length > 2 ? parts[2] : "1";
        }
        if (!StringUtils.isInteger(times)) {
            return "Illegal times " + times + ", must be integer.";
        }
        Invoker<?> invoker = null;
        for (Exporter<?> exporter : DubboProtocol.getDubboProtocol().getExporters()) {
            if (!service.equals(exporter.getInvoker().getInterface().getSimpleName()) && !service.equals(exporter.getInvoker().getInterface().getName()) && !service.equals(exporter.getInvoker().getUrl().getPath())) continue;
            invoker = exporter.getInvoker();
            break;
        }
        if (invoker != null) {
            if (method != null && method.length() > 0) {
                boolean found = false;
                for (Method m : invoker.getInterface().getMethods()) {
                    if (!m.getName().equals(method)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return "No such method " + method + " in class " + invoker.getInterface().getName();
                }
            }
        } else {
            return "No such service " + service;
        }
        TraceFilter.addTracer(invoker.getInterface(), method, channel, Integer.parseInt(times));
        return null;
    }
}

