/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.injvm;

import java.util.Map;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcContext;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.protocol.AbstractInvoker;
import kd.bos.krpc.rpc.protocol.injvm.InjvmExporter;
import kd.bos.krpc.rpc.protocol.injvm.InjvmProtocol;

class InjvmInvoker<T>
extends AbstractInvoker<T> {
    private final String key;
    private final Map<String, Exporter<?>> exporterMap;

    InjvmInvoker(Class<T> type, URL url, String key, Map<String, Exporter<?>> exporterMap) {
        super(type, url);
        this.key = key;
        this.exporterMap = exporterMap;
    }

    @Override
    public boolean isAvailable() {
        InjvmExporter exporter = (InjvmExporter)this.exporterMap.get(this.key);
        if (exporter == null) {
            return false;
        }
        return super.isAvailable();
    }

    @Override
    public Result doInvoke(Invocation invocation) throws Throwable {
        Exporter<?> exporter = InjvmProtocol.getExporter(this.exporterMap, this.getUrl());
        if (exporter == null) {
            throw new RpcException("Service [" + this.key + "] not found.");
        }
        RpcContext.getContext().setRemoteAddress("127.0.0.1", 0);
        return exporter.getInvoker().invoke(invocation);
    }
}

