/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.protocol.injvm;

import java.util.Map;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.common.utils.UrlUtils;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Protocol;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.protocol.AbstractProtocol;
import kd.bos.krpc.rpc.protocol.injvm.InjvmExporter;
import kd.bos.krpc.rpc.protocol.injvm.InjvmInvoker;
import kd.bos.krpc.rpc.support.ProtocolUtils;

public class InjvmProtocol
extends AbstractProtocol
implements Protocol {
    public static final String NAME = "injvm";
    public static final int DEFAULT_PORT = 0;
    private static InjvmProtocol INSTANCE;

    @Override
    public int getDefaultPort() {
        return 0;
    }

    public InjvmProtocol() {
        INSTANCE = this;
    }

    public static InjvmProtocol getInjvmProtocol() {
        if (INSTANCE == null) {
            ExtensionLoader.getExtensionLoader(Protocol.class).getExtension(NAME);
        }
        return INSTANCE;
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        return new InjvmExporter<T>(invoker, invoker.getUrl().getServiceKey(), this.exporterMap);
    }

    @Override
    public <T> Invoker<T> refer(Class<T> serviceType, URL url) throws RpcException {
        return new InjvmInvoker<T>(serviceType, url, url.getServiceKey(), this.exporterMap);
    }

    static Exporter<?> getExporter(Map<String, Exporter<?>> map, URL key) {
        Exporter<?> result = null;
        if (!key.getServiceKey().contains("*")) {
            result = map.get(key.getServiceKey());
        } else if (map != null && !map.isEmpty()) {
            for (Exporter<?> exporter : map.values()) {
                if (!UrlUtils.isServiceKeyMatch(key, exporter.getInvoker().getUrl())) continue;
                result = exporter;
                break;
            }
        }
        if (result == null) {
            return null;
        }
        if (ProtocolUtils.isGeneric(result.getInvoker().getUrl().getParameter("generic"))) {
            return null;
        }
        return result;
    }

    public boolean isInjvmRefer(URL url) {
        String scope = url.getParameter("scope");
        boolean isJvmRefer = NAME.toString().equals(url.getProtocol()) ? false : ("local".equals(scope) || url.getParameter(NAME, false) ? true : ("remote".equals(scope) ? false : (url.getParameter("generic", false) ? false : InjvmProtocol.getExporter(this.exporterMap, url) != null)));
        return isJvmRefer;
    }
}

