/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.proxy;

import java.lang.reflect.InvocationTargetException;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.RpcResult;

public abstract class AbstractProxyInvoker<T>
implements Invoker<T> {
    private final T proxy;
    private final Class<T> type;
    private final URL url;

    public AbstractProxyInvoker(T proxy, Class<T> type, URL url) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy == null");
        }
        if (type == null) {
            throw new IllegalArgumentException("interface == null");
        }
        if (!type.isInstance(proxy)) {
            throw new IllegalArgumentException(proxy.getClass().getName() + " not implement interface " + type);
        }
        this.proxy = proxy;
        this.type = type;
        this.url = url;
    }

    @Override
    public Class<T> getInterface() {
        return this.type;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        try {
            return new RpcResult(this.doInvoke(this.proxy, invocation.getMethodName(), invocation.getParameterTypes(), invocation.getArguments()));
        }
        catch (InvocationTargetException e) {
            return new RpcResult(e.getTargetException());
        }
        catch (Throwable e) {
            throw new RpcException("Failed to invoke remote proxy method " + invocation.getMethodName() + " to " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    protected abstract Object doInvoke(T var1, String var2, Class<?>[] var3, Object[] var4) throws Throwable;

    public String toString() {
        return this.getInterface() + " -> " + this.getUrl() == null ? " " : this.getUrl().toString();
    }
}

