/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.proxy.wrapper;

import java.lang.reflect.Constructor;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.Version;
import kd.bos.krpc.common.bytecode.Wrapper;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.ConfigUtils;
import kd.bos.krpc.common.utils.NetUtils;
import kd.bos.krpc.common.utils.ReflectUtils;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Protocol;
import kd.bos.krpc.rpc.ProxyFactory;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.service.GenericService;

public class StubProxyFactoryWrapper
implements ProxyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(StubProxyFactoryWrapper.class);
    private final ProxyFactory proxyFactory;
    private Protocol protocol;

    public StubProxyFactoryWrapper(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker) throws RpcException {
        String stub;
        Object proxy = this.proxyFactory.getProxy(invoker);
        if (GenericService.class != invoker.getInterface() && ConfigUtils.isNotEmpty(stub = invoker.getUrl().getParameter("stub", invoker.getUrl().getParameter("local")))) {
            Class<T> serviceType = invoker.getInterface();
            if (ConfigUtils.isDefault(stub)) {
                stub = invoker.getUrl().hasParameter("stub") ? serviceType.getName() + "Stub" : serviceType.getName() + "Local";
            }
            try {
                Class<?> stubClass = ReflectUtils.forName(stub);
                if (!serviceType.isAssignableFrom(stubClass)) {
                    throw new IllegalStateException("The stub implemention class " + stubClass.getName() + " not implement interface " + serviceType.getName());
                }
                try {
                    Constructor<?> constructor = ReflectUtils.findConstructor(stubClass, serviceType);
                    proxy = constructor.newInstance(proxy);
                    URL url = invoker.getUrl();
                    if (url.getParameter("dubbo.stub.event", false)) {
                        url = url.addParameter("dubbo.stub.event.methods", StringUtils.join(Wrapper.getWrapper(proxy.getClass()).getDeclaredMethodNames(), ","));
                        url = url.addParameter("isserver", Boolean.FALSE.toString());
                        try {
                            this.export(proxy, invoker.getInterface(), url);
                        }
                        catch (Exception e) {
                            LOGGER.error("export a stub service error.", e);
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("No such constructor \"public " + stubClass.getSimpleName() + "(" + serviceType.getName() + ")\" in stub implemention class " + stubClass.getName(), e);
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to create stub implemention class " + stub + " in consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", cause: " + t.getMessage(), t);
            }
        }
        return (T)proxy;
    }

    @Override
    public <T> Invoker<T> getInvoker(T proxy, Class<T> type, URL url) throws RpcException {
        return this.proxyFactory.getInvoker(proxy, type, url);
    }

    private <T> Exporter<T> export(T instance, Class<T> type, URL url) {
        return this.protocol.export(this.proxyFactory.getInvoker(instance, type, url));
    }
}

