/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.validation.filter;

import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.utils.ConfigUtils;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.validation.Validation;
import kd.bos.krpc.validation.Validator;

@Activate(group={"consumer", "provider"}, value={"validation"}, order=10000)
public class ValidationFilter
implements Filter {
    private Validation validation;

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.validation != null && !invocation.getMethodName().startsWith("$") && ConfigUtils.isNotEmpty(invoker.getUrl().getMethodParameter(invocation.getMethodName(), "validation"))) {
            try {
                Validator validator = this.validation.getValidator(invoker.getUrl());
                if (validator != null) {
                    validator.validate(invocation.getMethodName(), invocation.getParameterTypes(), invocation.getArguments());
                }
            }
            catch (RpcException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RpcException(t.getMessage(), t);
            }
        }
        return invoker.invoke(invocation);
    }
}

