/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.bc.cms.jcajce;

import cn.tca.TopBasicCrypto.asn1.ASN1Null;
import cn.tca.TopBasicCrypto.asn1.ASN1Object;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.RC2CBCParameter;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSAlgorithm;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedDataGenerator;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.jcajce.JcaJceHelper;
import cn.tca.TopBasicCrypto.operator.AsymmetricKeyUnwrapper;
import cn.tca.TopBasicCrypto.operator.SymmetricKeyUnwrapper;
import cn.topca.security.bc.jcajce.JcaJceHelperAgent;
import cn.topca.security.sm.CipherAgent;
import cn.topca.security.sm.KeyGeneratorAgent;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class EnvelopedDataHelper {
    protected static final Map<ASN1ObjectIdentifier, String> BASE_CIPHER_NAMES = new HashMap<ASN1ObjectIdentifier, String>();
    protected static final Map<ASN1ObjectIdentifier, String> CIPHER_ALG_NAMES = new HashMap<ASN1ObjectIdentifier, String>();
    protected static final Map<ASN1ObjectIdentifier, String> MAC_ALG_NAMES = new HashMap<ASN1ObjectIdentifier, String>();
    private static final short[] rc2Table;
    private JcaJceHelperAgent helper;

    EnvelopedDataHelper(JcaJceHelper helper) {
        this.helper = new JcaJceHelperAgent(helper);
    }

    String getBaseCipherName(ASN1ObjectIdentifier algorithm) {
        String name = BASE_CIPHER_NAMES.get(algorithm);
        if (name == null) {
            return algorithm.getId();
        }
        return name;
    }

    CipherAgent createCipher(ASN1ObjectIdentifier algorithm) throws CMSException {
        try {
            String cipherName = CIPHER_ALG_NAMES.get(algorithm);
            if (cipherName != null) {
                try {
                    return this.helper.createCipher(cipherName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.helper.createCipher(algorithm.getId());
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("cannot create cipher: " + e.getMessage(), (Exception)e);
        }
    }

    Mac createMac(ASN1ObjectIdentifier algorithm) throws CMSException {
        try {
            String macName = MAC_ALG_NAMES.get(algorithm);
            if (macName != null) {
                try {
                    return this.helper.createMac(macName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.helper.createMac(algorithm.getId());
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("cannot create mac: " + e.getMessage(), (Exception)e);
        }
    }

    CipherAgent createRFC3211Wrapper(ASN1ObjectIdentifier algorithm) throws CMSException {
        String cipherName = BASE_CIPHER_NAMES.get(algorithm);
        if (cipherName == null) {
            throw new CMSException("no name for " + algorithm);
        }
        cipherName = cipherName + "RFC3211Wrap";
        try {
            return this.helper.createCipher(cipherName);
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("cannot create cipher: " + e.getMessage(), (Exception)e);
        }
    }

    KeyAgreement createKeyAgreement(ASN1ObjectIdentifier algorithm) throws CMSException {
        try {
            String agreementName = BASE_CIPHER_NAMES.get(algorithm);
            if (agreementName != null) {
                try {
                    return this.helper.createKeyAgreement(agreementName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.helper.createKeyAgreement(algorithm.getId());
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("cannot create key pair generator: " + e.getMessage(), (Exception)e);
        }
    }

    AlgorithmParameterGenerator createAlgorithmParameterGenerator(ASN1ObjectIdentifier algorithm) throws GeneralSecurityException {
        String algorithmName = BASE_CIPHER_NAMES.get(algorithm);
        if (algorithmName != null) {
            try {
                return this.helper.createAlgorithmParameterGenerator(algorithmName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return this.helper.createAlgorithmParameterGenerator(algorithm.getId());
    }

    Cipher createContentCipher(final Key sKey, final AlgorithmIdentifier encryptionAlgID) throws CMSException {
        return (Cipher)EnvelopedDataHelper.execute(new JCECallback(){

            public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
                CipherAgent cipher = EnvelopedDataHelper.this.createCipher(encryptionAlgID.getAlgorithm());
                ASN1Object sParams = (ASN1Object)encryptionAlgID.getParameters().getDERObject();
                String encAlg = encryptionAlgID.getAlgorithm().getId();
                if (sParams != null && !(sParams instanceof ASN1Null)) {
                    try {
                        AlgorithmParameters params = EnvelopedDataHelper.this.createAlgorithmParameters(encryptionAlgID.getAlgorithm());
                        try {
                            params.init(sParams.getEncoded(), "ASN.1");
                        }
                        catch (IOException e) {
                            throw new CMSException("error decoding algorithm parameters.", (Exception)e);
                        }
                        cipher.init(2, sKey, params);
                    }
                    catch (NoSuchAlgorithmException e) {
                        if (encAlg.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || encAlg.equals("1.3.6.1.4.1.188.7.1.1.2") || encAlg.equals(CMSEnvelopedDataGenerator.AES128_CBC) || encAlg.equals(CMSEnvelopedDataGenerator.AES192_CBC) || encAlg.equals(CMSEnvelopedDataGenerator.AES256_CBC)) {
                            cipher.init(2, sKey, new IvParameterSpec(ASN1OctetString.getInstance((Object)sParams).getOctets()));
                        }
                        throw e;
                    }
                } else if (encAlg.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || encAlg.equals("1.3.6.1.4.1.188.7.1.1.2") || encAlg.equals("1.2.840.113533.7.66.10")) {
                    cipher.init(2, sKey, new IvParameterSpec(new byte[8]));
                } else {
                    cipher.init(2, sKey);
                }
                return cipher;
            }
        });
    }

    Mac createContentMac(final Key sKey, final AlgorithmIdentifier macAlgId) throws CMSException {
        return (Mac)EnvelopedDataHelper.execute(new JCECallback(){

            public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
                Mac mac = EnvelopedDataHelper.this.createMac(macAlgId.getAlgorithm());
                ASN1Object sParams = (ASN1Object)macAlgId.getParameters().getDERObject();
                if (sParams != null && !(sParams instanceof ASN1Null)) {
                    AlgorithmParameters params = EnvelopedDataHelper.this.createAlgorithmParameters(macAlgId.getAlgorithm());
                    try {
                        params.init(sParams.getEncoded(), "ASN.1");
                    }
                    catch (IOException e) {
                        throw new CMSException("error decoding algorithm parameters.", (Exception)e);
                    }
                    mac.init(sKey, params.getParameterSpec(IvParameterSpec.class));
                }
                mac.init(sKey);
                return mac;
            }
        });
    }

    AlgorithmParameters createAlgorithmParameters(ASN1ObjectIdentifier algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        String algorithmName = BASE_CIPHER_NAMES.get(algorithm);
        if (algorithmName != null) {
            try {
                return this.helper.createAlgorithmParameters(algorithmName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return this.helper.createAlgorithmParameters(algorithm.getId());
    }

    KeyPairGenerator createKeyPairGenerator(DERObjectIdentifier algorithm) throws CMSException {
        try {
            String cipherName = BASE_CIPHER_NAMES.get(algorithm);
            if (cipherName != null) {
                try {
                    return this.helper.createKeyPairGenerator(cipherName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.helper.createKeyPairGenerator(algorithm.getId());
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("cannot create key pair generator: " + e.getMessage(), (Exception)e);
        }
    }

    public KeyGeneratorAgent createKeyGenerator(ASN1ObjectIdentifier algorithm) throws CMSException {
        try {
            String cipherName = BASE_CIPHER_NAMES.get(algorithm);
            if (cipherName != null) {
                try {
                    return this.helper.createKeyGenerator(cipherName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.helper.createKeyGenerator(algorithm.getId());
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("cannot create key generator: " + e.getMessage(), (Exception)e);
        }
    }

    AlgorithmParameters generateParameters(ASN1ObjectIdentifier encryptionOID, SecretKey encKey, SecureRandom rand) throws CMSException {
        try {
            AlgorithmParameterGenerator pGen = this.createAlgorithmParameterGenerator(encryptionOID);
            if (encryptionOID.equals((Object)CMSEnvelopedDataGenerator.RC2_CBC)) {
                byte[] iv = new byte[8];
                rand.nextBytes(iv);
                try {
                    pGen.init(new RC2ParameterSpec(encKey.getEncoded().length * 8, iv), rand);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CMSException("parameters generation error: " + e, (Exception)e);
                }
            }
            return pGen.generateParameters();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("exception creating algorithm parameter generator: " + e, (Exception)e);
        }
    }

    AlgorithmIdentifier getAlgorithmIdentifier(ASN1ObjectIdentifier encryptionOID, AlgorithmParameters params) throws CMSException {
        DERNull asn1Params;
        if (params != null) {
            try {
                asn1Params = ASN1Object.fromByteArray((byte[])params.getEncoded("ASN.1"));
            }
            catch (IOException e) {
                throw new CMSException("cannot encode parameters: " + e.getMessage(), (Exception)e);
            }
        } else {
            asn1Params = DERNull.INSTANCE;
        }
        return new AlgorithmIdentifier((DERObjectIdentifier)encryptionOID, (DEREncodable)asn1Params);
    }

    static Object execute(JCECallback callback) throws CMSException {
        try {
            return callback.doInJCE();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", (Exception)e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", (Exception)e);
        }
        catch (NoSuchProviderException e) {
            throw new CMSException("can't find provider.", (Exception)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", (Exception)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameters invalid.", (Exception)e);
        }
        catch (InvalidParameterSpecException e) {
            throw new CMSException("MAC algorithm parameter spec invalid.", (Exception)e);
        }
    }

    public KeyFactory createKeyFactory(ASN1ObjectIdentifier algorithm) throws CMSException {
        try {
            String cipherName = BASE_CIPHER_NAMES.get(algorithm);
            if (cipherName != null) {
                try {
                    return this.helper.createKeyFactory(cipherName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.helper.createKeyFactory(algorithm.getId());
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("cannot create key factory: " + e.getMessage(), (Exception)e);
        }
    }

    public AsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey) {
        return this.helper.createAsymmetricUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey);
    }

    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, SecretKey keyEncryptionKey) {
        return this.helper.createSymmetricUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier(ASN1ObjectIdentifier macOID, AlgorithmParameterSpec paramSpec) {
        if (paramSpec instanceof IvParameterSpec) {
            return new AlgorithmIdentifier((DERObjectIdentifier)macOID, (DEREncodable)new DEROctetString(((IvParameterSpec)paramSpec).getIV()));
        }
        if (paramSpec instanceof RC2ParameterSpec) {
            RC2ParameterSpec rc2Spec = (RC2ParameterSpec)paramSpec;
            int effKeyBits = ((RC2ParameterSpec)paramSpec).getEffectiveKeyBits();
            if (effKeyBits != -1) {
                int parameterVersion = effKeyBits < 256 ? rc2Table[effKeyBits] : effKeyBits;
                return new AlgorithmIdentifier((DERObjectIdentifier)macOID, (DEREncodable)new RC2CBCParameter(parameterVersion, rc2Spec.getIV()));
            }
            return new AlgorithmIdentifier((DERObjectIdentifier)macOID, (DEREncodable)new RC2CBCParameter(rc2Spec.getIV()));
        }
        throw new IllegalStateException("unknown parameter spec");
    }

    static {
        BASE_CIPHER_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES256_CBC, "AES");
        BASE_CIPHER_NAMES.put(new ASN1ObjectIdentifier("1.2.156.10197.1.104"), "SM4");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES128_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES192_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES256_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.rsaEncryption.getId()), "RSA/ECB/PKCS1Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAST5_CBC, "CAST5/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA128_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA192_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA256_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.SEED_CBC, "SEED/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(new ASN1ObjectIdentifier("1.2.156.10197.1.104"), "SM4/CBC/PKCS5Padding");
        MAC_ALG_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDEMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES128_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES192_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES256_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.RC2_CBC, "RC2Mac");
        rc2Table = new short[]{189, 86, 234, 242, 162, 241, 172, 42, 176, 147, 209, 156, 27, 51, 253, 208, 48, 4, 182, 220, 125, 223, 50, 75, 247, 203, 69, 155, 49, 187, 33, 90, 65, 159, 225, 217, 74, 77, 158, 218, 160, 104, 44, 195, 39, 95, 128, 54, 62, 238, 251, 149, 26, 254, 206, 168, 52, 169, 19, 240, 166, 63, 216, 12, 120, 36, 175, 35, 82, 193, 103, 23, 245, 102, 144, 231, 232, 7, 184, 96, 72, 230, 30, 83, 243, 146, 164, 114, 140, 8, 21, 110, 134, 0, 132, 250, 244, 127, 138, 66, 25, 246, 219, 205, 20, 141, 80, 18, 186, 60, 6, 78, 236, 179, 53, 17, 161, 136, 142, 43, 148, 153, 183, 113, 116, 211, 228, 191, 58, 222, 150, 14, 188, 10, 237, 119, 252, 55, 107, 3, 121, 137, 98, 198, 215, 192, 210, 124, 106, 139, 34, 163, 91, 5, 93, 2, 117, 213, 97, 227, 24, 143, 85, 81, 173, 31, 11, 94, 133, 229, 194, 87, 99, 202, 61, 108, 180, 197, 204, 112, 178, 145, 89, 13, 71, 32, 200, 79, 88, 224, 1, 226, 22, 56, 196, 111, 59, 15, 101, 70, 190, 126, 45, 123, 130, 249, 64, 181, 29, 115, 248, 235, 38, 199, 135, 151, 37, 84, 177, 40, 170, 152, 157, 165, 100, 109, 122, 212, 16, 129, 68, 239, 73, 214, 174, 46, 221, 118, 92, 47, 167, 28, 201, 9, 105, 154, 131, 207, 41, 57, 185, 233, 76, 255, 67, 171};
    }

    static interface JCECallback {
        public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException;
    }
}

