/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.bc.jcajce;

import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.jcajce.JcaJceHelper;
import cn.tca.TopBasicCrypto.operator.AsymmetricKeyUnwrapper;
import cn.tca.TopBasicCrypto.operator.SymmetricKeyUnwrapper;
import cn.topca.security.sm.CipherAgent;
import cn.topca.security.sm.KeyGeneratorAgent;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class JcaJceHelperAgent {
    private JcaJceHelper helper;

    public JcaJceHelperAgent(JcaJceHelper helper) {
        this.helper = helper;
    }

    public CipherAgent createCipher(String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        try {
            return new CipherAgent(this.helper.createCipher(algorithm));
        }
        catch (Exception exception) {
            return CipherAgent.getInstance(algorithm);
        }
    }

    public Mac createMac(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createMac(algorithm);
    }

    public KeyAgreement createKeyAgreement(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createKeyAgreement(algorithm);
    }

    public AlgorithmParameterGenerator createAlgorithmParameterGenerator(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createAlgorithmParameterGenerator(algorithm);
    }

    public AlgorithmParameters createAlgorithmParameters(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createAlgorithmParameters(algorithm);
    }

    public KeyGeneratorAgent createKeyGenerator(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        try {
            return new KeyGeneratorAgent(this.helper.createKeyGenerator(algorithm));
        }
        catch (Exception exception) {
            return KeyGeneratorAgent.getInstance(algorithm);
        }
    }

    public KeyFactory createKeyFactory(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createKeyFactory(algorithm);
    }

    public KeyPairGenerator createKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createKeyPairGenerator(algorithm);
    }

    public MessageDigest createDigest(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createDigest(algorithm);
    }

    public Signature createSignature(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createSignature(algorithm);
    }

    public CertificateFactory createCertificateFactory(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        return this.helper.createCertificateFactory(algorithm);
    }

    public AsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey) {
        return this.helper.createAsymmetricUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey);
    }

    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, SecretKey keyEncryptionKey) {
        return this.helper.createSymmetricUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey);
    }
}

