/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.sm.SM2Cipher;
import cn.topca.security.sm.SM4Cipher;
import cn.topca.security.sm.TopSMProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CipherAgent {
    private static final Logger log = LoggerFactory.getLogger((String)"TopCipherProxy");
    private final CipherSpi spi;
    private final Provider provider;
    private final Cipher cipher;
    private static final Provider p = TopSMProvider.INSTANCE;
    private static final String KEY_USAGE_EXTENSION_OID = "2.5.29.15";

    public CipherAgent(Cipher cipher) {
        log.debug("#compatibility");
        log.debug("use JCE Cipher for " + cipher.getAlgorithm());
        this.cipher = cipher;
        this.spi = null;
        this.provider = cipher.getProvider();
    }

    private CipherAgent(CipherSpi spi, Provider provider) {
        this.cipher = null;
        this.spi = spi;
        this.provider = provider;
    }

    public static CipherAgent getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (transformation.startsWith("SM2")) {
            return new CipherAgent(new SM2Cipher(), p);
        }
        if (transformation.startsWith("SM4")) {
            return new CipherAgent(new SM4Cipher(transformation), p);
        }
        return new CipherAgent(Cipher.getInstance(transformation));
    }

    public static CipherAgent getInstance(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            Cipher cipher = Cipher.getInstance(transformation, provider);
            return new CipherAgent(cipher);
        }
        catch (Exception e) {
            CipherSpi spi = null;
            String[] tran = transformation.split("/");
            Provider.Service service = provider.getService("Cipher", transformation);
            spi = (CipherSpi)service.newInstance(null);
            if (spi == null) {
                throw new NoSuchAlgorithmException(transformation);
            }
            return new CipherAgent(spi, provider);
        }
    }

    public static CipherAgent getInstance(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return CipherAgent.getInstance(transformation, p);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        if (this.cipher != null) {
            return this.cipher.getAlgorithm();
        }
        return "SM2";
    }

    public final int getBlockSize() {
        if (this.cipher != null) {
            return this.cipher.getBlockSize();
        }
        return (Integer)this.invokeSpi("engineGetBlockSize", null, new Object[0]);
    }

    public final int getOutputSize(int inputLen) {
        if (this.cipher != null) {
            return this.cipher.getOutputSize(inputLen);
        }
        return (Integer)this.invokeSpi("engineGetOutputSize", new Class[]{Integer.TYPE}, inputLen);
    }

    public final byte[] getIV() {
        if (this.cipher != null) {
            return this.cipher.getIV();
        }
        return (byte[])this.invokeSpi("engineGetIV", null, new Object[0]);
    }

    public final AlgorithmParameters getParameters() {
        if (this.cipher != null) {
            return this.cipher.getParameters();
        }
        return (AlgorithmParameters)this.invokeSpi("engineGetParameters", null, new Object[0]);
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        if (this.cipher != null) {
            this.cipher.init(opmode, key);
            return;
        }
        this.invokeSpi("engineInit", new Class[]{Integer.TYPE, Key.class, SecureRandom.class}, opmode, key, new SecureRandom());
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (this.cipher != null) {
            this.cipher.init(opmode, key, random);
            return;
        }
        this.invokeSpi("engineInit", new Class[]{Integer.TYPE, Key.class, SecureRandom.class}, opmode, key, random);
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipher != null) {
            this.cipher.init(opmode, key, params);
            return;
        }
        this.init(opmode, key, params, null);
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipher != null) {
            this.cipher.init(opmode, key, params, random);
            return;
        }
        this.invokeSpi("engineInit", new Class[]{Integer.TYPE, Key.class, AlgorithmParameterSpec.class, SecureRandom.class}, opmode, key, params, random);
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipher != null) {
            this.cipher.init(opmode, key, params);
            return;
        }
        this.init(opmode, key, params, null);
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipher != null) {
            this.cipher.init(opmode, key, params, random);
            return;
        }
        this.invokeSpi("engineInit", new Class[]{Integer.TYPE, Key.class, AlgorithmParameters.class, SecureRandom.class}, opmode, key, params, random);
    }

    public final void init(int opmode, Certificate certificate) throws InvalidKeyException {
        if (this.cipher != null) {
            this.cipher.init(opmode, certificate);
            return;
        }
        this.init(opmode, certificate, null);
    }

    public final void init(int opmode, Certificate certificate, SecureRandom random) throws InvalidKeyException {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (this.cipher != null) {
            this.cipher.init(opmode, certificate, random);
            return;
        }
        if (certificate instanceof X509Certificate && (critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !critSet.isEmpty() && critSet.contains(KEY_USAGE_EXTENSION_OID) && (keyUsageInfo = cert.getKeyUsage()) != null && (opmode == 1 && keyUsageInfo.length > 3 && !keyUsageInfo[3] || opmode == 3 && keyUsageInfo.length > 2 && !keyUsageInfo[2])) {
            throw new InvalidKeyException("Wrong key usage");
        }
        PublicKey publicKey = certificate == null ? null : certificate.getPublicKey();
        this.invokeSpi("engineInit", new Class[]{Integer.TYPE, Key.class, SecureRandom.class}, opmode, publicKey, random);
    }

    public final byte[] update(byte[] input) {
        if (this.cipher != null) {
            return this.cipher.update(input);
        }
        if (input == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        if (input.length == 0) {
            return null;
        }
        return (byte[])this.invokeSpi("engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, 0, input.length);
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLen) {
        if (this.cipher != null) {
            return this.cipher.update(input, inputOffset, inputLen);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return null;
        }
        return (byte[])this.invokeSpi("engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, inputOffset, inputLen);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException {
        if (this.cipher != null) {
            return this.cipher.update(input, inputOffset, inputLen, output);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        return (Integer)this.invokeSpi("engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, input, inputOffset, inputLen, output, 0);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0 || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        return (Integer)this.invokeSpi("engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, input, inputOffset, inputLen, output, outputOffset);
    }

    public final int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        if (this.cipher != null) {
            return this.cipher.update(input, output);
        }
        if (input == null || output == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (input == output) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (output.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return (Integer)this.invokeSpi("engineUpdate", new Class[]{ByteBuffer.class, ByteBuffer.class}, input, output);
    }

    public final byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        if (this.cipher != null) {
            return this.cipher.doFinal();
        }
        return (byte[])this.invokeSpi("engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new byte[0], 0, 0);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (this.cipher != null) {
            return this.cipher.doFinal(output, outputOffset);
        }
        if (output == null || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return (Integer)this.invokeSpi("engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, null, 0, 0, output, outputOffset);
    }

    public final byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        if (this.cipher != null) {
            return this.cipher.doFinal(input);
        }
        return (byte[])this.invokeSpi("engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, 0, input.length);
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.cipher != null) {
            return this.cipher.doFinal(input, inputOffset, inputLen);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return (byte[])this.invokeSpi("engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, inputOffset, inputLen);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.cipher != null) {
            return this.cipher.doFinal(input, inputOffset, inputLen, output);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return (Integer)this.invokeSpi("engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, input, inputOffset, inputLen, output, 0);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.cipher != null) {
            return this.cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0 || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return (Integer)this.invokeSpi("engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, input, inputOffset, inputLen, output, outputOffset);
    }

    public final int doFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.cipher != null) {
            return this.cipher.doFinal(input, output);
        }
        if (input == null || output == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (input == output) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (output.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return (Integer)this.invokeSpi("engineDoFinal", new Class[]{ByteBuffer.class, ByteBuffer.class}, input, output);
    }

    public final byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.cipher != null) {
            return this.cipher.wrap(key);
        }
        return (byte[])this.invokeSpi("engineWrap", new Class[]{Key.class}, key);
    }

    public final Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.cipher != null) {
            return this.cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
        }
        if (wrappedKeyType != 3 && wrappedKeyType != 2 && wrappedKeyType != 1) {
            throw new InvalidParameterException("Invalid key type");
        }
        return (Key)this.invokeSpi("engineUnwrap", new Class[]{byte[].class, String.class, Integer.TYPE}, wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    private Object invokeSpi(String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            Method method;
            try {
                method = this.spi.getClass().getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                method = this.spi.getClass().getMethod(methodName, parameterTypes);
            }
            return method.invoke((Object)this.spi, args);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Cipher getCipher() {
        return this.cipher;
    }
}

