/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import java.io.IOException;
import java.io.InputStream;

public class PEMUtil {
    private final String _header1;
    private final String _header2;
    private final String _footer1;
    private final String _footer2;

    PEMUtil(String type) {
        this._header1 = "-----BEGIN " + type + "-----";
        this._header2 = "-----BEGIN X509 " + type + "-----";
        this._footer1 = "-----END " + type + "-----";
        this._footer2 = "-----END X509 " + type + "-----";
    }

    private String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer l = new StringBuffer();
        while (true) {
            if ((c = in.read()) != 13 && c != 10 && c >= 0) {
                if (c == 13) continue;
                l.append((char)c);
                continue;
            }
            if (c < 0 || l.length() != 0) break;
        }
        if (c < 0) {
            return null;
        }
        return l.toString();
    }

    ASN1Sequence readPEMObject(InputStream in) throws IOException {
        String line;
        StringBuffer pemBuf = new StringBuffer();
        while ((line = this.readLine(in)) != null && !line.startsWith(this._header1) && !line.startsWith(this._header2)) {
            if (!line.matches("\\s*M\\w+\\s*")) continue;
            pemBuf.append(line);
            break;
        }
        while ((line = this.readLine(in)) != null && !line.startsWith(this._footer1) && !line.startsWith(this._footer2)) {
            pemBuf.append(line);
        }
        if (pemBuf.length() != 0) {
            ASN1InputStream asn1In = new ASN1InputStream(Base64.decode((String)pemBuf.toString()));
            DERObject o = asn1In.readObject();
            asn1In.close();
            if (!(o instanceof ASN1Sequence)) {
                throw new IOException("malformed PEM data encountered");
            }
            return (ASN1Sequence)o;
        }
        return null;
    }
}

