/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ec.ECParameters;
import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerOutputStream;
import cn.topca.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECPoint;
import org.apache.commons.codec.binary.Hex;

public class SM2EncData {
    private ECPoint c1Point;
    private byte[] c3Hash;
    private byte[] c2Data;

    public SM2EncData() {
    }

    public SM2EncData(byte[] sm2EncData) throws IOException {
        DerInputStream sequence = new DerInputStream(sm2EncData);
        DerValue[] vector = sequence.getSequence(4);
        if (vector.length != 4) {
            throw new IOException("Invalid data");
        }
        BigInteger x = vector[0].getPositiveBigInteger();
        BigInteger y = vector[1].getPositiveBigInteger();
        this.c1Point = new ECPoint(x, y);
        byte[] data1 = vector[2].getOctetString();
        byte[] data2 = vector[3].getOctetString();
        if (data1.length == 32) {
            this.c3Hash = data1;
            this.c2Data = data2;
        } else {
            this.c2Data = data2;
            this.c3Hash = data1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEncoded() {
        DerOutputStream sequence = new DerOutputStream();
        DerOutputStream vector = new DerOutputStream();
        try {
            vector.write((byte)2, ECParameters.trimZeroes(this.c1Point.getAffineX().toByteArray()));
            vector.write((byte)2, ECParameters.trimZeroes(this.c1Point.getAffineY().toByteArray()));
            vector.write((byte)4, this.c3Hash);
            vector.write((byte)4, this.c2Data);
            sequence.write((byte)48, vector);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (sequence != null) {
                    sequence.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sequence.toByteArray();
    }

    public void setC1Point(ECPoint c1Point) {
        this.c1Point = c1Point;
    }

    public void setC3Hash(byte[] c3Hash) {
        this.c3Hash = c3Hash;
    }

    public void setC2Data(byte[] c2Data) {
        this.c2Data = c2Data;
    }

    public ECPoint getC1Point() {
        return this.c1Point;
    }

    public byte[] getC3Hash() {
        return this.c3Hash;
    }

    public byte[] getC2Data() {
        return this.c2Data;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1120);
        info.append("SM2 encrypted data [");
        info.append("X:" + this.c1Point.getAffineX().toString(16));
        info.append(", Y:" + this.c1Point.getAffineY().toString(16));
        info.append(", Hash(" + this.c3Hash.length + "):" + Hex.encodeHexString((byte[])this.c3Hash));
        info.append(", EncData(" + this.c2Data.length + "):" + Hex.encodeHexString((byte[])this.c2Data));
        info.append("]\n");
        info.append("DER:\n");
        info.append(Hex.encodeHexString((byte[])this.getEncoded()) + "\n");
        return info.toString();
    }
}

