/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ec.NamedCurve;
import cn.topca.security.sm.SM2KeyFactory;
import cn.topca.security.sm.SM2PublicKey;
import cn.topca.security.sm.SM2UserID;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2GenParameterSpec
extends ECGenParameterSpec {
    private static final Logger log = LoggerFactory.getLogger(SM2GenParameterSpec.class);
    private SM2UserID userID;
    private ECPublicKey publicKey;
    private boolean isTesting = false;

    protected SM2GenParameterSpec() {
        super("SM2GenParameterSpec");
    }

    public SM2GenParameterSpec(String userIDString) {
        super(userIDString);
        this.userID = new SM2UserID(userIDString.getBytes());
    }

    public SM2GenParameterSpec(SM2UserID userID, PublicKey publicKey) throws InvalidKeyException {
        super(userID.toString());
        this.userID = userID;
        this.publicKey = (ECPublicKey)SM2KeyFactory.toSM2Key(publicKey);
    }

    public SM2UserID getUserID() {
        return this.userID;
    }

    public void setUserID(SM2UserID userID) {
        this.userID = userID;
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = (ECPublicKey)SM2KeyFactory.toSM2Key(publicKey);
    }

    public boolean readyForGenerateZ() {
        return this.userID != null && this.publicKey != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateZ() {
        log.trace("Start generate Z...");
        log.trace("Z=H256(ENTL || UserID || a || b || gx || gy || x || y)");
        if (this.userID == null) {
            throw new NullPointerException("userID can not be null.");
        }
        if (this.publicKey == null) {
            throw new NullPointerException("publicKey can not be null.");
        }
        ECParameterSpec sm2curve = this.getPublicKey().getParams();
        if (sm2curve == null) {
            sm2curve = NamedCurve.getECParameterSpec("SM2");
        }
        String digestAlgName = "SM3";
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgName);
            log.trace("H256 Algorithm is " + md.getAlgorithm());
            md.reset();
            md.update(this.userID.getENTL());
            log.trace("ENTL  :" + Hex.encodeHexString((byte[])this.userID.getENTL()));
            log.trace("UserID:" + Hex.encodeHexString((byte[])this.userID.getUserID()));
            md.update(this.userID.getUserID());
            log.trace("ECParameterSpec is " + sm2curve);
            md.update(this.getMagnitude(sm2curve.getCurve().getA()));
            md.update(this.getMagnitude(sm2curve.getCurve().getB()));
            md.update(this.getMagnitude(sm2curve.getGenerator().getAffineX()));
            md.update(this.getMagnitude(sm2curve.getGenerator().getAffineY()));
            log.trace("PublicKey is " + this.getPublicKey());
            md.update(this.getMagnitude(this.getPublicKey().getW().getAffineX()));
            md.update(this.getMagnitude(this.getPublicKey().getW().getAffineY()));
            byte[] z = md.digest();
            log.trace("Z=" + Hex.encodeHexString((byte[])z));
            if (this.isTesting) {
                String check = "F4A38489E32B45B6F876E3AC2168CA392362DC8F23459C1D1146FC3DBFB7BC9A";
                try {
                    log.trace("Assert Z=" + check + ", " + Arrays.equals(z, Hex.decodeHex((char[])check.toCharArray())));
                }
                catch (DecoderException e) {
                    e.printStackTrace();
                }
            }
            byte[] byArray = z;
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            log.trace("Finish generate Z.");
        }
    }

    public SM2GenParameterSpec test() {
        this.isTesting = true;
        return this;
    }

    protected static final SM2GenParameterSpec getTestGenParameterSpec() throws InvalidKeyException, InvalidParameterSpecException {
        SM2UserID userId = new SM2UserID("ALICE123@YAHOO.COM".getBytes());
        SM2PublicKey publicKey = SM2PublicKey.getTestKey();
        return new SM2GenParameterSpec(userId, publicKey).test();
    }

    private byte[] getMagnitude(BigInteger bi) {
        byte[] b = bi.toByteArray();
        if (b.length > 1 && b[0] == 0) {
            int len = b.length - 1;
            byte[] tmp = new byte[len];
            System.arraycopy(b, 1, tmp, 0, len);
            return tmp;
        }
        return b;
    }
}

