/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ec.ECUtil;
import cn.topca.security.jca.JCAJCEUtil;
import cn.topca.security.sm.SM2Core;
import cn.topca.security.sm.SM2PrivateKey;
import cn.topca.security.sm.SM2PublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public class SM2KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final ECParameterSpec sm2Curve = SM2Core.sm2Curve;
    private static final int KEYSIZE = sm2Curve.getCurve().getField().getFieldSize();
    private SecureRandom random;

    public void initialize(int keysize, SecureRandom random) {
        if (keysize != KEYSIZE) {
            throw new RuntimeException("SM2 key size must be 256.");
        }
        this.random = random;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) {
        if (!(params instanceof ECParameterSpec)) {
            throw new RuntimeException("Only ECParameterSpec supported");
        }
        this.random = random;
    }

    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = JCAJCEUtil.getSecureRandom();
        }
        BigInteger s = ECUtil.getRandomMultiple(sm2Curve);
        ECPoint w = ECUtil.getECPoint(sm2Curve, s);
        try {
            return new KeyPair(new SM2PublicKey(w, sm2Curve), new SM2PrivateKey(s, w, sm2Curve));
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidParameterSpecException e) {
            e.printStackTrace();
        }
        return null;
    }
}

