/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.sm.SM4Constants;
import cn.topca.security.sm.SymmetricCipher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;

public class SM4Crypt
extends SymmetricCipher
implements SM4Constants {
    private static final byte[][] SBOX = new byte[][]{{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5}, {43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103}, {-100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98}, {-28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90}, {71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88}, {104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53}, {30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121}, {-44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98}, {-22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95}, {-32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29}, {29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111}, {-43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81}, {-115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40}, {10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80}, {-119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124}, {24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72}};
    private static final int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};
    private static final int[] FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    private static final int ROUND = 32;
    public boolean v = false;
    private int[] rk;

    private byte Sbox(byte src) {
        int row = src >> 4 & 0xF;
        int column = src & 0xF;
        return SBOX[row][column];
    }

    private void F(int[] x, int[] rk, int i) throws IOException {
        int n = (i + 0) % 4;
        x[n] = x[n] ^ this.T(x[(i + 1) % 4] ^ x[(i + 2) % 4] ^ x[(i + 3) % 4] ^ rk[i]);
    }

    private int T(int src) {
        return this.L(this.Tau(src));
    }

    private int T_(int src) {
        return this.L_(this.Tau(src));
    }

    private int Tau(int A) {
        byte[] a = this.convertToBytes(A);
        byte[] b = new byte[4];
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.Sbox(a[i]);
        }
        return this.convertToInt(b);
    }

    private int L(int B) {
        return B ^ Integer.rotateLeft(B, 2) ^ Integer.rotateLeft(B, 10) ^ Integer.rotateLeft(B, 18) ^ Integer.rotateLeft(B, 24);
    }

    private int L_(int B) {
        return B ^ Integer.rotateLeft(B, 13) ^ Integer.rotateLeft(B, 23);
    }

    private byte[] R(int[] x) {
        return this.convertToBytes(this.reverse(x));
    }

    private int[] R_(byte[] encBlock) throws IOException {
        return this.reverse(this.convertToIntArray(encBlock));
    }

    private int[] reverse(int[] in) {
        int[] out = (int[])in.clone();
        int leftOffset = 0;
        for (int rightOffset = out.length - 1; leftOffset < rightOffset; ++leftOffset, --rightOffset) {
            int temp = out[leftOffset];
            out[leftOffset] = out[rightOffset];
            out[rightOffset] = temp;
        }
        return out;
    }

    private byte[] convertToBytes(int[] in) {
        byte[] out = new byte[in.length << 2];
        for (int i = 0; i < in.length; ++i) {
            System.arraycopy(this.convertToBytes(in[i]), 0, out, 0 + i << 2, 4);
        }
        return out;
    }

    private int[] convertToIntArray(byte[] in) throws IOException {
        assert (in.length % 4 == 0);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(in);
        int[] out = new int[in.length >> 2];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.readInt(inputStream);
        }
        return out;
    }

    public byte[] encryptBlock(byte[] originBlock) throws IOException {
        int[] x = this.convertToIntArray(originBlock);
        for (int i = 0; i < 32; ++i) {
            try {
                this.F(x, this.rk, i);
                if (!this.v) continue;
                System.out.println("rk[" + i + "]=" + Integer.toHexString(this.rk[i]) + "    X[" + i + "]=" + Integer.toHexString(x[i % 4]));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] encData = this.R(x);
        return encData;
    }

    public byte[] decryptBlock(byte[] encData) throws IOException {
        int[] x = this.R_(encData);
        for (int i = 0; i < 32; ++i) {
            int index = 32 - i - 1;
            try {
                this.F(x, this.rk, index);
                if (!this.v) continue;
                System.out.println("rk[" + index + "]=" + Integer.toHexString(this.rk[index]) + "    X[" + index + "]=" + Integer.toHexString(x[index % 4]));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] decData = this.convertToBytes(x);
        return decData;
    }

    protected int[] genRk(byte[] mk) throws IOException {
        int i;
        ByteArrayInputStream mkInStream = new ByteArrayInputStream(mk);
        int[] k = new int[4];
        int[] rk = new int[32];
        for (i = 0; i < 4; ++i) {
            int mkElement = this.readInt(mkInStream);
            k[i] = mkElement ^ FK[i];
        }
        for (i = 0; i < 32; ++i) {
            int n = (i + 0) % 4;
            int n2 = k[n] ^ this.T_(k[(i + 1) % 4] ^ k[(i + 2) % 4] ^ k[(i + 3) % 4] ^ CK[i]);
            k[n] = n2;
            rk[i] = n2;
        }
        return rk;
    }

    private int readInt(InputStream inputStream) throws IOException {
        byte[] n = new byte[4];
        if (inputStream.read(n) != 4) {
            throw new IOException("no integer in inputStream");
        }
        return this.convertToInt(n);
    }

    private int convertToInt(byte[] b) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n |= (b[i] & 0xFF) << 8 * (3 - i);
        }
        return n;
    }

    private byte[] convertToBytes(int n) {
        byte[] b = new byte[4];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(n >> 8 * (3 - i) & 0xFF);
        }
        return b;
    }

    static final boolean isKeySizeValid(int len) {
        for (int i = 0; i < SM4_KEYSIZES.length; ++i) {
            if (len != SM4_KEYSIZES[i]) continue;
            return true;
        }
        return false;
    }

    int getBlockSize() {
        return 16;
    }

    void init(boolean decrypting, String algorithm, byte[] key) throws InvalidKeyException {
        if (!SM4Crypt.isKeySizeValid(key.length)) {
            throw new InvalidKeyException("Invalid SMS4 key length: " + key.length + " bytes");
        }
        try {
            this.rk = this.genRk(key);
        }
        catch (IOException e) {
            throw new InvalidKeyException(e);
        }
    }

    void encryptBlock(byte[] plain, int plainOffset, byte[] cipher, int cipherOffset) {
        byte[] oriData = new byte[16];
        byte[] encData = null;
        System.arraycopy(plain, plainOffset, oriData, 0, oriData.length);
        try {
            encData = this.encryptBlock(oriData);
            System.arraycopy(encData, 0, cipher, cipherOffset, encData.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void decryptBlock(byte[] cipher, int cipherOffset, byte[] plain, int plainOffset) {
        byte[] encData = new byte[16];
        byte[] decData = null;
        System.arraycopy(cipher, cipherOffset, encData, 0, encData.length);
        try {
            decData = this.decryptBlock(encData);
            System.arraycopy(decData, 0, plain, plainOffset, decData.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

