/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.asn1.x509.X509CertificateStructure;
import cn.tca.TopBasicCrypto.jce.provider.X509CertificateObject;
import cn.topca.security.sm.SM2PublicKey;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;

public class SMCertificate
extends X509CertificateObject {
    private final SubjectPublicKeyInfo publicKeyInfo;
    public static final byte[] NONE_SIG = new byte[20];

    public SMCertificate(X509CertificateStructure c) throws CertificateParsingException {
        super(c);
        this.publicKeyInfo = c.getSubjectPublicKeyInfo();
    }

    public PublicKey getPublicKey() {
        try {
            return super.getPublicKey();
        }
        catch (Exception e) {
            try {
                return new SM2PublicKey(this.publicKeyInfo.getDEREncoded());
            }
            catch (InvalidKeyException ex) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] getSignature() {
        byte[] sig = super.getSignature();
        if (sig == null || sig.length == 0) {
            return NONE_SIG;
        }
        return sig;
    }
}

