/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.util;

public class X500NameTokenizer {
    private String value;
    private int index;
    private char seperator;
    private StringBuffer buf = new StringBuffer();

    public X500NameTokenizer(String oid) {
        this(oid, ',');
    }

    public X500NameTokenizer(String oid, char seperator) {
        this.value = oid;
        this.index = -1;
        this.seperator = seperator;
    }

    public boolean hasMoreTokens() {
        return this.index != this.value.length();
    }

    public String nextToken() {
        int end;
        if (this.index == this.value.length()) {
            return null;
        }
        boolean quoted = false;
        boolean escaped = false;
        this.buf.setLength(0);
        for (end = this.index + 1; end != this.value.length(); ++end) {
            char c = this.value.charAt(end);
            if (c == '\"') {
                if (!escaped) {
                    quoted = !quoted;
                } else {
                    this.buf.append(c);
                }
                escaped = false;
                continue;
            }
            if (escaped || quoted) {
                if (c == '#' && this.buf.charAt(this.buf.length() - 1) == '=') {
                    this.buf.append('\\');
                } else if (c == '+' && this.seperator != '+') {
                    this.buf.append('\\');
                }
                this.buf.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == this.seperator) break;
            this.buf.append(c);
        }
        this.index = end;
        return this.buf.toString().trim();
    }
}

