/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509.extension.logotype;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERIA5String;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import java.math.BigInteger;

public class LogotypeAudioInfo
extends ASN1Encodable {
    DERInteger fileSize;
    DERInteger playTime;
    DERInteger channels;
    DERInteger sampleRate;
    DERIA5String language;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogotypeAudioInfo(ASN1Sequence sequence) {
        if (sequence.size() < 3) throw new IllegalArgumentException("sequence must have more than 3 elements. not: " + sequence.size());
        this.fileSize = DERInteger.getInstance((Object)sequence.getObjectAt(0));
        this.playTime = DERInteger.getInstance((Object)sequence.getObjectAt(1));
        this.channels = DERInteger.getInstance((Object)sequence.getObjectAt(2));
        this.sampleRate = null;
        this.language = null;
        if (sequence.size() < 4) throw new IllegalArgumentException("sequence must have more than 3 elements. not: " + sequence.size());
        DERTaggedObject four = (DERTaggedObject)sequence.getObjectAt(3);
        if (four.getTagNo() == 3) {
            this.sampleRate = (DERInteger)four.getObject();
        } else {
            if (four.getTagNo() != 4) throw new IllegalArgumentException("unknown tag" + four.getTagNo());
            this.language = (DERIA5String)four.getObject();
        }
        if (sequence.size() != 5) throw new IllegalArgumentException("more than 5 elements in sequence: " + sequence.size());
        DERTaggedObject five = (DERTaggedObject)sequence.getObjectAt(4);
        if (five.getTagNo() == 3) {
            this.sampleRate = (DERInteger)five.getObject();
            throw new IllegalArgumentException("sequence must have more than 3 elements. not: " + sequence.size());
        } else {
            if (five.getTagNo() != 4) throw new IllegalArgumentException("unknown tag" + five.getTagNo());
            this.language = (DERIA5String)five.getObject();
        }
        throw new IllegalArgumentException("sequence must have more than 3 elements. not: " + sequence.size());
    }

    public LogotypeAudioInfo(BigInteger fileSize, BigInteger playTime, BigInteger channels, BigInteger sampleRate, String language) {
        fileSize = null;
        playTime = null;
        channels = null;
        sampleRate = null;
        language = null;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.fileSize);
        v.add((DEREncodable)this.playTime);
        v.add((DEREncodable)this.channels);
        v.add((DEREncodable)this.sampleRate);
        v.add((DEREncodable)this.language);
        if (this.sampleRate != null) {
            v.add((DEREncodable)this.sampleRate);
        }
        if (this.language != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)this.language));
        }
        return new DERSequence(v);
    }
}

