/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509.extension.logotype;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERIA5String;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.x509.DigestInfo;
import java.util.Vector;

public class LogotypeDetails
extends ASN1Encodable {
    DERIA5String mediaType = null;
    ASN1Sequence logotypeHash = null;
    ASN1Sequence logotypeURI = null;

    public static LogotypeDetails getInstance(ASN1TaggedObject obj, boolean explicit) {
        return LogotypeDetails.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static LogotypeDetails getInstance(Object obj) {
        if (obj instanceof LogotypeDetails) {
            return (LogotypeDetails)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new LogotypeDetails((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public LogotypeDetails(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("size of sequence must be 3 not " + seq.size());
        }
        this.mediaType = DERIA5String.getInstance((Object)seq.getObjectAt(0));
        this.logotypeHash = ASN1Sequence.getInstance((Object)seq.getObjectAt(1));
        this.logotypeURI = ASN1Sequence.getInstance((Object)seq.getObjectAt(2));
    }

    public LogotypeDetails(String mediaType, DigestInfo[] logotypeHash, String[] logotypeURI) {
        this.mediaType = new DERIA5String(mediaType);
        this.logotypeHash = new DERSequence((ASN1Encodable[])logotypeHash);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < logotypeURI.length; ++i) {
            v.add((DEREncodable)new DERIA5String(logotypeURI[i]));
        }
        this.logotypeURI = new DERSequence(v);
    }

    public String getMediaType() {
        return this.mediaType.getString();
    }

    public DigestInfo[] getLogotypeHash() {
        Vector<DigestInfo> v = new Vector<DigestInfo>();
        for (int i = 0; i < this.logotypeHash.size(); ++i) {
            v.add(DigestInfo.getInstance((Object)this.logotypeHash.getObjectAt(i)));
        }
        DigestInfo[] infos = v.toArray(new DigestInfo[this.logotypeHash.size()]);
        return infos;
    }

    public String[] getLogotypeURI() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.logotypeURI.size(); ++i) {
            v.add(DERIA5String.getInstance((Object)this.logotypeURI.getObjectAt(i)).getString());
        }
        String[] infos = v.toArray(new String[this.logotypeURI.size()]);
        return infos;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.mediaType);
        v.add((DEREncodable)this.logotypeHash);
        v.add((DEREncodable)this.logotypeURI);
        return new DERSequence(v);
    }
}

