/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509.extension.logotype;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERIA5String;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.topca.security.x509.extension.logotype.LogotypeImageResolution;

public class LogotypeImageInfo
extends ASN1Encodable {
    public static final DERInteger grayScale = new DERInteger(0);
    public static final DERInteger color = new DERInteger(1);
    DERInteger type = color;
    DERInteger fileSize = null;
    DERInteger xSize = null;
    DERInteger ySize = null;
    LogotypeImageResolution resolution = null;
    DERIA5String language = null;

    public static LogotypeImageInfo getInstance(Object obj) {
        ASN1Sequence seq;
        if (obj == null || obj instanceof LogotypeImageInfo) {
            return (LogotypeImageInfo)((Object)obj);
        }
        if (obj instanceof ASN1Sequence && (seq = (ASN1Sequence)obj).size() >= 4) {
            DERInteger type = (DERInteger)seq.getObjectAt(0);
            DERInteger fileSize = (DERInteger)seq.getObjectAt(1);
            DERInteger xSize = (DERInteger)seq.getObjectAt(2);
            DERInteger ySize = (DERInteger)seq.getObjectAt(3);
            return new LogotypeImageInfo(type.getValue().intValue(), fileSize.getValue().intValue(), xSize.getValue().intValue(), ySize.getValue().intValue());
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public LogotypeImageInfo(int type, int fileSizeInOctets, int xSize, int ySize) {
        this.type = new DERInteger(type);
        this.fileSize = new DERInteger(fileSizeInOctets);
        this.xSize = new DERInteger(xSize);
        this.ySize = new DERInteger(ySize);
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        DERTaggedObject t = new DERTaggedObject(0, (DEREncodable)this.type);
        v.add((DEREncodable)t);
        v.add((DEREncodable)this.fileSize);
        v.add((DEREncodable)this.xSize);
        v.add((DEREncodable)this.ySize);
        if (this.resolution != null) {
            v.add((DEREncodable)this.resolution);
        }
        if (this.language != null) {
            v.add((DEREncodable)this.language);
        }
        return new DERSequence(v);
    }
}

