/*
 * Decompiled with CFR 0.152.
 */
package kd.kuep.capp.sdk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.kuep.capp.model.card.ChartCard;
import kd.kuep.capp.model.card.enums.ColorEnum;

public class ChartCardProxy {
    private ChartCard chartCard = new ChartCard();

    public ChartCardProxy() {
        this.chartCard.setMainData(new HashMap<String, Object>());
        this.chartCard.setDataList(new ArrayList<Map<String, Object>>());
        this.chartCard.setAdditional(new HashMap<String, Object>());
        this.chartCard.setQuery(new ArrayList<Map<String, Object>>());
    }

    public void setMainData(String label, String value, String labelColor, String valueColor) {
        this.chartCard.getMainData().put("label", label);
        this.chartCard.getMainData().put("value", value);
        this.chartCard.getMainData().put("labelColor", labelColor == null ? ColorEnum.LabelColor.getRGB() : labelColor);
        this.chartCard.getMainData().put("valueColor", valueColor == null ? ColorEnum.ValueColor.getRGB() : valueColor);
    }

    public void setAdditional(String label, String value, String labelColor, String valueColor) {
        this.chartCard.getAdditional().put("label", label);
        this.chartCard.getAdditional().put("value", value);
        this.chartCard.getAdditional().put("labelColor", labelColor == null ? ColorEnum.LabelColor.getRGB() : labelColor);
        this.chartCard.getAdditional().put("valueColor", valueColor == null ? ColorEnum.ValueColor.getRGB() : valueColor);
    }

    public ChartCard getChartCard() {
        return this.chartCard;
    }

    public void addDataList(String label, String value, String labelColor, String valueColor) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("label", label);
        map.put("value", value);
        map.put("labelColor", labelColor == null ? ColorEnum.LabelColor.getRGB() : labelColor);
        map.put("valueColor", labelColor == null ? ColorEnum.ValueColor.getRGB() : valueColor);
        this.chartCard.getDataList().add(map);
    }

    public void addDataList(String color, String label, String value, String labelColor, String valueColor) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("color", color);
        map.put("label", label);
        map.put("value", value);
        map.put("labelColor", labelColor == null ? ColorEnum.LabelColor.getRGB() : labelColor);
        map.put("valueColor", labelColor == null ? ColorEnum.ValueColor.getRGB() : valueColor);
        this.chartCard.getDataList().add(map);
    }

    public void addQuery(Map<String, Object> map) {
        this.chartCard.getQuery().add(map);
    }

    public void addDataRangeQueryMap(String startDate, String endData, String rangeType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "dataRange");
        map.put("startDate", startDate);
        map.put("endData", endData);
        map.put("rangeType", rangeType);
        this.chartCard.getQuery().add(map);
    }

    public void addMemberQueryMap(String empids, String deptids, String names) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "member");
        map.put("empids", empids);
        map.put("deptids", deptids);
        map.put("names", names);
        this.chartCard.getQuery().add(map);
    }
}

