/*
 * Decompiled with CFR 0.152.
 */
package kd.kuep.capp.sdk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.kuep.capp.model.card.DataListCard;
import kd.kuep.capp.model.card.enums.ColorEnum;

public class DataListCardProxy {
    private DataListCard card = new DataListCard();

    public DataListCardProxy() {
        this.card.setMainData(new HashMap<String, Object>());
        this.card.setAdditional(new HashMap<String, Object>());
        this.card.setDataList(new ArrayList<Map<String, Object>>());
        this.card.setQuery(new ArrayList<Map<String, Object>>());
    }

    public void setMainData(String label, String value, String labelColor, String valueColor) {
        this.card.getMainData().put("label", label);
        this.card.getMainData().put("value", value);
        this.card.getMainData().put("labelColor", labelColor == null ? ColorEnum.LabelColor.getRGB() : labelColor);
        this.card.getMainData().put("valueColor", valueColor == null ? ColorEnum.ValueColor.getRGB() : valueColor);
    }

    public void setAdditional(String label, String value, String labelColor, String valueColor) {
        this.card.getAdditional().put("label", label);
        this.card.getAdditional().put("value", value);
        this.card.getAdditional().put("labelColor", labelColor == null ? ColorEnum.LabelColor.getRGB() : labelColor);
        this.card.getAdditional().put("valueColor", valueColor == null ? ColorEnum.ValueColor.getRGB() : valueColor);
    }

    public DataListCard getDataListCard() {
        return this.card;
    }

    public void addDataList(String label, String value, String desc, String imgUrl, String linkType, String linkUrl, String labelColor, String valueColor) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("label", label);
        map.put("value", value);
        map.put("desc", desc);
        map.put("imgUrl", imgUrl);
        map.put("linkType", linkType == null ? "webview" : linkType);
        map.put("linkUrl", linkUrl);
        map.put("labelColor", labelColor == null ? ColorEnum.LabelColor.getRGB() : labelColor);
        map.put("valueColor", labelColor == null ? ColorEnum.ValueColor.getRGB() : valueColor);
        this.card.getDataList().add(map);
    }

    public void addQuery(Map<String, Object> map) {
        this.card.getQuery().add(map);
    }

    public void addDataRangeQueryMap(String startDate, String endData, String rangeType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "dataRange");
        map.put("startDate", startDate);
        map.put("endData", endData);
        map.put("rangeType", rangeType);
        this.card.getQuery().add(map);
    }

    public void addMemberQueryMap(String empids, String deptids, String names) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "member");
        map.put("empids", empids);
        map.put("deptids", deptids);
        map.put("names", names);
        this.card.getQuery().add(map);
    }
}

