/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.io.IIOAdapter;
import com.hankcs.hanlp.dependency.nnparser.NeuralNetworkDependencyParser;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.PinyinDictionary;
import com.hankcs.hanlp.dictionary.ts.HongKongToSimplifiedChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.HongKongToTaiwanChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.HongKongToTraditionalChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.SimplifiedChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.SimplifiedToHongKongChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.SimplifiedToTaiwanChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.TaiwanToHongKongChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.TaiwanToSimplifiedChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.TaiwanToTraditionalChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.TraditionalChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.TraditionalToHongKongChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.TraditionalToTaiwanChineseDictionary;
import com.hankcs.hanlp.mining.phrase.MutualInformationEntropyPhraseExtractor;
import com.hankcs.hanlp.mining.word.NewWordDiscover;
import com.hankcs.hanlp.mining.word.WordInfo;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.Viterbi.ViterbiSegment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.TextRankKeyword;
import com.hankcs.hanlp.summary.TextRankSentence;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class HanLP {
    private HanLP() {
    }

    public static String convertToSimplifiedChinese(String traditionalChineseString) {
        return TraditionalChineseDictionary.convertToSimplifiedChinese(traditionalChineseString.toCharArray());
    }

    public static String convertToTraditionalChinese(String simplifiedChineseString) {
        return SimplifiedChineseDictionary.convertToTraditionalChinese(simplifiedChineseString.toCharArray());
    }

    public static String s2t(String s) {
        return HanLP.convertToTraditionalChinese(s);
    }

    public static String t2s(String t) {
        return HanLP.convertToSimplifiedChinese(t);
    }

    public static String s2tw(String s) {
        return SimplifiedToTaiwanChineseDictionary.convertToTraditionalTaiwanChinese(s);
    }

    public static String tw2s(String tw) {
        return TaiwanToSimplifiedChineseDictionary.convertToSimplifiedChinese(tw);
    }

    public static String s2hk(String s) {
        return SimplifiedToHongKongChineseDictionary.convertToTraditionalHongKongChinese(s);
    }

    public static String hk2s(String hk) {
        return HongKongToSimplifiedChineseDictionary.convertToSimplifiedChinese(hk);
    }

    public static String t2tw(String t) {
        return TraditionalToTaiwanChineseDictionary.convertToTaiwanChinese(t);
    }

    public static String tw2t(String tw) {
        return TaiwanToTraditionalChineseDictionary.convertToTraditionalChinese(tw);
    }

    public static String t2hk(String t) {
        return TraditionalToHongKongChineseDictionary.convertToHongKongTraditionalChinese(t);
    }

    public static String hk2t(String hk) {
        return HongKongToTraditionalChineseDictionary.convertToTraditionalChinese(hk);
    }

    public static String hk2tw(String hk) {
        return HongKongToTaiwanChineseDictionary.convertToTraditionalTaiwanChinese(hk);
    }

    public static String tw2hk(String tw) {
        return TaiwanToHongKongChineseDictionary.convertToTraditionalHongKongChinese(tw);
    }

    public static String convertToPinyinString(String text, String separator, boolean remainNone) {
        List<Pinyin> pinyinList = PinyinDictionary.convertToPinyin(text, true);
        int length = pinyinList.size();
        StringBuilder sb = new StringBuilder(length * (5 + separator.length()));
        int i = 1;
        for (Pinyin pinyin : pinyinList) {
            if (pinyin == Pinyin.none5 && !remainNone) {
                sb.append(text.charAt(i - 1));
            } else {
                sb.append(pinyin.getPinyinWithoutTone());
            }
            if (i < length) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<Pinyin> convertToPinyinList(String text) {
        return PinyinDictionary.convertToPinyin(text);
    }

    public static String convertToPinyinFirstCharString(String text, String separator, boolean remainNone) {
        List<Pinyin> pinyinList = PinyinDictionary.convertToPinyin(text, remainNone);
        int length = pinyinList.size();
        StringBuilder sb = new StringBuilder(length * (1 + separator.length()));
        int i = 1;
        for (Pinyin pinyin : pinyinList) {
            sb.append(pinyin.getFirstChar());
            if (i < length) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<Term> segment(String text) {
        return StandardTokenizer.segment(text.toCharArray());
    }

    public static Segment newSegment() {
        return new ViterbiSegment();
    }

    public static CoNLLSentence parseDependency(String sentence) {
        return NeuralNetworkDependencyParser.compute(sentence);
    }

    public static List<String> extractPhrase(String text, int size) {
        MutualInformationEntropyPhraseExtractor extractor = new MutualInformationEntropyPhraseExtractor();
        return extractor.extractPhrase(text, size);
    }

    public static List<WordInfo> extractWords(String text, int size) {
        return HanLP.extractWords(text, size, false);
    }

    public static List<WordInfo> extractWords(BufferedReader reader, int size) throws IOException {
        return HanLP.extractWords(reader, size, false);
    }

    public static List<WordInfo> extractWords(String text, int size, boolean newWordsOnly) {
        NewWordDiscover discover = new NewWordDiscover(4, 0.0f, 0.5f, 100.0f, newWordsOnly);
        return discover.discover(text, size);
    }

    public static List<WordInfo> extractWords(BufferedReader reader, int size, boolean newWordsOnly) throws IOException {
        NewWordDiscover discover = new NewWordDiscover(4, 0.0f, 0.5f, 100.0f, newWordsOnly);
        return discover.discover(reader, size);
    }

    public static List<String> extractKeyword(String document, int size) {
        return TextRankKeyword.getKeywordList(document, size);
    }

    public static List<String> extractSummary(String document, int size) {
        return TextRankSentence.getTopSentenceList(document, size);
    }

    public static String getSummary(String document, int max_length) {
        return TextRankSentence.getSummary(document, max_length);
    }

    public static List<String> extractSummary(String document, int size, String sentence_separator) {
        return TextRankSentence.getTopSentenceList(document, size, sentence_separator);
    }

    public static String getSummary(String document, int max_length, String sentence_separator) {
        return TextRankSentence.getSummary(document, max_length, sentence_separator);
    }

    public static final class Config {
        public static boolean DEBUG;
        public static String CoreDictionaryPath;
        public static String CoreDictionaryTransformMatrixDictionaryPath;
        public static String[] CustomDictionaryPath;
        public static String BiGramDictionaryPath;
        public static String CoreStopWordDictionaryPath;
        public static String CoreSynonymDictionaryDictionaryPath;
        public static String PersonDictionaryPath;
        public static String PersonDictionaryTrPath;
        public static String PlaceDictionaryPath;
        public static String PlaceDictionaryTrPath;
        public static String OrganizationDictionaryPath;
        public static String OrganizationDictionaryTrPath;
        public static String tcDictionaryRoot;
        public static String SYTDictionaryPath;
        public static String PinyinDictionaryPath;
        public static String TranslatedPersonDictionaryPath;
        public static String JapanesePersonDictionaryPath;
        public static String CharTypePath;
        public static String CharTablePath;
        public static String WordNatureModelPath;
        public static String MaxEntModelPath;
        public static String NNParserModelPath;
        public static String CRFSegmentModelPath;
        public static String HMMSegmentModelPath;
        public static String CRFDependencyModelPath;
        public static boolean ShowTermNature;
        public static boolean Normalization;
        public static IIOAdapter IOAdapter;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            StringBuilder sbInfo;
            block17: {
                int n;
                int n2;
                String[] stringArray;
                DEBUG = false;
                CoreDictionaryPath = "data/dictionary/CoreNatureDictionary.txt";
                CoreDictionaryTransformMatrixDictionaryPath = "data/dictionary/CoreNatureDictionary.tr.txt";
                CustomDictionaryPath = new String[]{"data/dictionary/custom/CustomDictionary.txt"};
                BiGramDictionaryPath = "data/dictionary/CoreNatureDictionary.ngram.txt";
                CoreStopWordDictionaryPath = "data/dictionary/stopwords.txt";
                CoreSynonymDictionaryDictionaryPath = "data/dictionary/synonym/CoreSynonym.txt";
                PersonDictionaryPath = "data/dictionary/person/nr.txt";
                PersonDictionaryTrPath = "data/dictionary/person/nr.tr.txt";
                PlaceDictionaryPath = "data/dictionary/place/ns.txt";
                PlaceDictionaryTrPath = "data/dictionary/place/ns.tr.txt";
                OrganizationDictionaryPath = "data/dictionary/organization/nt.txt";
                OrganizationDictionaryTrPath = "data/dictionary/organization/nt.tr.txt";
                tcDictionaryRoot = "data/dictionary/tc/";
                SYTDictionaryPath = "data/dictionary/pinyin/SYTDictionary.txt";
                PinyinDictionaryPath = "data/dictionary/pinyin/pinyin.txt";
                TranslatedPersonDictionaryPath = "data/dictionary/person/nrf.txt";
                JapanesePersonDictionaryPath = "data/dictionary/person/nrj.txt";
                CharTypePath = "data/dictionary/other/CharType.bin";
                CharTablePath = "data/dictionary/other/CharTable.txt";
                WordNatureModelPath = "data/model/dependency/WordNature.txt";
                MaxEntModelPath = "data/model/dependency/MaxEntModel.txt";
                NNParserModelPath = "data/model/dependency/NNParserModel.txt";
                CRFSegmentModelPath = "data/model/segment/CRFSegmentModel.txt";
                HMMSegmentModelPath = "data/model/segment/HMMSegmentModel.bin";
                CRFDependencyModelPath = "data/model/dependency/CRFDependencyModelMini.txt";
                ShowTermNature = true;
                Normalization = false;
                Properties p = new Properties();
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (loader == null) {
                        loader = Config.class.getClassLoader();
                    }
                    p.load(new InputStreamReader(Predefine.HANLP_PROPERTIES_PATH == null ? loader.getResourceAsStream("hanlp.properties") : new FileInputStream(Predefine.HANLP_PROPERTIES_PATH), "UTF-8"));
                    String root = p.getProperty("root", "").replaceAll("\\\\", "/");
                    if (root.length() > 0 && !root.endsWith("/")) {
                        root = String.valueOf(root) + "/";
                    }
                    CoreDictionaryPath = String.valueOf(root) + p.getProperty("CoreDictionaryPath", CoreDictionaryPath);
                    CoreDictionaryTransformMatrixDictionaryPath = String.valueOf(root) + p.getProperty("CoreDictionaryTransformMatrixDictionaryPath", CoreDictionaryTransformMatrixDictionaryPath);
                    BiGramDictionaryPath = String.valueOf(root) + p.getProperty("BiGramDictionaryPath", BiGramDictionaryPath);
                    CoreStopWordDictionaryPath = String.valueOf(root) + p.getProperty("CoreStopWordDictionaryPath", CoreStopWordDictionaryPath);
                    CoreSynonymDictionaryDictionaryPath = String.valueOf(root) + p.getProperty("CoreSynonymDictionaryDictionaryPath", CoreSynonymDictionaryDictionaryPath);
                    PersonDictionaryPath = String.valueOf(root) + p.getProperty("PersonDictionaryPath", PersonDictionaryPath);
                    PersonDictionaryTrPath = String.valueOf(root) + p.getProperty("PersonDictionaryTrPath", PersonDictionaryTrPath);
                    String[] pathArray = p.getProperty("CustomDictionaryPath", "data/dictionary/custom/CustomDictionary.txt").split(";");
                    String prePath = root;
                    int i = 0;
                    while (true) {
                        if (i >= pathArray.length) {
                            CustomDictionaryPath = pathArray;
                            tcDictionaryRoot = String.valueOf(root) + p.getProperty("tcDictionaryRoot", tcDictionaryRoot);
                            if (!tcDictionaryRoot.endsWith("/")) {
                                tcDictionaryRoot = String.valueOf(tcDictionaryRoot) + '/';
                            }
                            SYTDictionaryPath = String.valueOf(root) + p.getProperty("SYTDictionaryPath", SYTDictionaryPath);
                            PinyinDictionaryPath = String.valueOf(root) + p.getProperty("PinyinDictionaryPath", PinyinDictionaryPath);
                            TranslatedPersonDictionaryPath = String.valueOf(root) + p.getProperty("TranslatedPersonDictionaryPath", TranslatedPersonDictionaryPath);
                            JapanesePersonDictionaryPath = String.valueOf(root) + p.getProperty("JapanesePersonDictionaryPath", JapanesePersonDictionaryPath);
                            PlaceDictionaryPath = String.valueOf(root) + p.getProperty("PlaceDictionaryPath", PlaceDictionaryPath);
                            PlaceDictionaryTrPath = String.valueOf(root) + p.getProperty("PlaceDictionaryTrPath", PlaceDictionaryTrPath);
                            OrganizationDictionaryPath = String.valueOf(root) + p.getProperty("OrganizationDictionaryPath", OrganizationDictionaryPath);
                            OrganizationDictionaryTrPath = String.valueOf(root) + p.getProperty("OrganizationDictionaryTrPath", OrganizationDictionaryTrPath);
                            CharTypePath = String.valueOf(root) + p.getProperty("CharTypePath", CharTypePath);
                            CharTablePath = String.valueOf(root) + p.getProperty("CharTablePath", CharTablePath);
                            WordNatureModelPath = String.valueOf(root) + p.getProperty("WordNatureModelPath", WordNatureModelPath);
                            MaxEntModelPath = String.valueOf(root) + p.getProperty("MaxEntModelPath", MaxEntModelPath);
                            NNParserModelPath = String.valueOf(root) + p.getProperty("NNParserModelPath", NNParserModelPath);
                            CRFSegmentModelPath = String.valueOf(root) + p.getProperty("CRFSegmentModelPath", CRFSegmentModelPath);
                            CRFDependencyModelPath = String.valueOf(root) + p.getProperty("CRFDependencyModelPath", CRFDependencyModelPath);
                            HMMSegmentModelPath = String.valueOf(root) + p.getProperty("HMMSegmentModelPath", HMMSegmentModelPath);
                            ShowTermNature = "true".equals(p.getProperty("ShowTermNature", "true"));
                            Normalization = "true".equals(p.getProperty("Normalization", "false"));
                            String ioAdapterClassName = p.getProperty("IOAdapter");
                            if (ioAdapterClassName == null) return;
                            try {
                                Class<?> clazz = Class.forName(ioAdapterClassName);
                                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                                Object instance = ctor.newInstance(new Object[0]);
                                if (instance == null) return;
                                IOAdapter = (IIOAdapter)instance;
                                return;
                            }
                            catch (ClassNotFoundException e) {
                                Predefine.logger.warning(String.format("\u627e\u4e0d\u5230IO\u9002\u914d\u5668\u7c7b\uff1a %s \uff0c\u8bf7\u68c0\u67e5\u7b2c\u4e09\u65b9\u63d2\u4ef6jar\u5305", ioAdapterClassName));
                                return;
                            }
                            catch (NoSuchMethodException e) {
                                Predefine.logger.warning(String.format("\u5de5\u5382\u7c7b[%s]\u6ca1\u6709\u9ed8\u8ba4\u6784\u9020\u65b9\u6cd5\uff0c\u4e0d\u7b26\u5408\u8981\u6c42", ioAdapterClassName));
                                return;
                            }
                            catch (SecurityException e) {
                                Predefine.logger.warning(String.format("\u5de5\u5382\u7c7b[%s]\u9ed8\u8ba4\u6784\u9020\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u4e0d\u7b26\u5408\u8981\u6c42", ioAdapterClassName));
                                return;
                            }
                            catch (Exception e) {
                                Predefine.logger.warning(String.format("\u5de5\u5382\u7c7b[%s]\u6784\u9020\u5931\u8d25\uff1a%s\n", ioAdapterClassName, TextUtility.exceptionToString(e)));
                                return;
                            }
                        }
                        if (pathArray[i].startsWith(" ")) {
                            pathArray[i] = String.valueOf(prePath) + pathArray[i].trim();
                        } else {
                            pathArray[i] = String.valueOf(root) + pathArray[i];
                            int lastSplash = pathArray[i].lastIndexOf(47);
                            if (lastSplash != -1) {
                                prePath = pathArray[i].substring(0, lastSplash + 1);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    sbInfo = new StringBuilder("========Tips========\n\u8bf7\u5c06hanlp.properties\u653e\u5728\u4e0b\u5217\u76ee\u5f55\uff1a\n");
                    String classPath = (String)System.getProperties().get("java.class.path");
                    if (classPath == null) break block17;
                    stringArray = classPath.split(File.pathSeparator);
                    n2 = stringArray.length;
                    n = 0;
                }
                while (n < n2) {
                    String path = stringArray[n];
                    if (new File(path).isDirectory()) {
                        sbInfo.append(path).append('\n');
                    }
                    ++n;
                }
            }
            sbInfo.append("Web\u9879\u76ee\u5219\u8bf7\u653e\u5230\u4e0b\u5217\u76ee\u5f55\uff1a\nWebapp/WEB-INF/lib\nWebapp/WEB-INF/classes\nAppserver/lib\nJRE/lib\n");
            sbInfo.append("\u5e76\u4e14\u7f16\u8f91root=PARENT/path/to/your/data\n");
            sbInfo.append("\u73b0\u5728HanLP\u5c06\u5c1d\u8bd5\u4ece").append(System.getProperties().get("user.dir")).append("\u8bfb\u53d6data\u2026\u2026");
            Predefine.logger.severe("\u6ca1\u6709\u627e\u5230hanlp.properties\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u627e\u4e0d\u5230data\n" + sbInfo);
        }

        public static void enableDebug() {
            Config.enableDebug(true);
        }

        public static void enableDebug(boolean enable) {
            DEBUG = enable;
            if (DEBUG) {
                Predefine.logger.setLevel(Level.ALL);
            } else {
                Predefine.logger.setLevel(Level.OFF);
            }
        }
    }
}

