/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.classifiers;

import com.hankcs.hanlp.classification.classifiers.NaiveBayesClassifier;
import com.hankcs.hanlp.classification.models.NaiveBayesModel;
import com.hankcs.hanlp.classification.utilities.TextProcessUtility;
import com.hankcs.hanlp.corpus.io.IOUtil;
import java.util.Map;
import junit.framework.TestCase;

public class NaiveBayesClassifierTest
extends TestCase {
    private static final String MODEL_PATH = "data/test/classification.ser";
    private Map<String, String[]> trainingDataSet;

    private void loadDataSet() {
        if (this.trainingDataSet != null) {
            return;
        }
        System.out.printf("\u6b63\u5728\u4ece %s \u4e2d\u52a0\u8f7d\u5206\u7c7b\u8bed\u6599...\n", "data/test/\u641c\u72d7\u6587\u672c\u5206\u7c7b\u8bed\u6599\u5e93\u8ff7\u4f60\u7248");
        this.trainingDataSet = TextProcessUtility.loadCorpus("data/test/\u641c\u72d7\u6587\u672c\u5206\u7c7b\u8bed\u6599\u5e93\u8ff7\u4f60\u7248");
        for (Map.Entry<String, String[]> entry : this.trainingDataSet.entrySet()) {
            System.out.printf("%s : %d \u4e2a\u6587\u6863\n", entry.getKey(), entry.getValue().length);
        }
    }

    public void testTrain() throws Exception {
        this.loadDataSet();
        NaiveBayesClassifier naiveBayesClassifier = new NaiveBayesClassifier();
        long start = System.currentTimeMillis();
        System.out.println("\u5f00\u59cb\u8bad\u7ec3...");
        naiveBayesClassifier.train(this.trainingDataSet);
        System.out.printf("\u8bad\u7ec3\u8017\u65f6\uff1a%d ms\n", System.currentTimeMillis() - start);
        IOUtil.saveObjectTo(naiveBayesClassifier.getNaiveBayesModel(), MODEL_PATH);
    }

    public void testPredictAndAccuracy() throws Exception {
        NaiveBayesModel model = (NaiveBayesModel)IOUtil.readObjectFrom(MODEL_PATH);
        if (model == null) {
            this.testTrain();
            model = (NaiveBayesModel)IOUtil.readObjectFrom(MODEL_PATH);
        }
        NaiveBayesClassifier naiveBayesClassifier = new NaiveBayesClassifier(model);
        String path = "data/test/\u641c\u72d7\u6587\u672c\u5206\u7c7b\u8bed\u6599\u5e93\u8ff7\u4f60\u7248/\u8d22\u7ecf/12.txt";
        String text = IOUtil.readTxt(path);
        String label = naiveBayesClassifier.classify(text);
        String title = text.split("\\n")[0].replaceAll("\\s", "");
        System.out.printf("\u300a%s\u300b \u5c5e\u4e8e\u5206\u7c7b \u3010%s\u3011\n", title, label);
        title = text = "2016\u5e74\u4e2d\u56fd\u94c1\u8def\u5b8c\u6210\u56fa\u5b9a\u8d44\u4ea7\u6295\u8d44\u5c06\u8fbe8000\u4ebf\u5143";
        label = naiveBayesClassifier.classify(text);
        System.out.printf("\u300a%s\u300b \u5c5e\u4e8e\u5206\u7c7b \u3010%s\u3011\n", title, label);
        title = text = "\u56fd\u5b892016\u8d5b\u5b63\u5e74\u7968\u5f00\u552e\u6bd4\u8d5b\u573a\u6b21\u51cf\u5c11\u5957\u7968\u5374\u4e0a\u6da8";
        label = naiveBayesClassifier.classify(text);
        System.out.printf("\u300a%s\u300b \u5c5e\u4e8e\u5206\u7c7b \u3010%s\u3011\n", title, label);
        int totalDocuments = 0;
        int rightDocuments = 0;
        this.loadDataSet();
        long start = System.currentTimeMillis();
        System.out.println("\u5f00\u59cb\u8bc4\u6d4b...");
        for (Map.Entry<String, String[]> entry : this.trainingDataSet.entrySet()) {
            String category = entry.getKey();
            String[] documents = entry.getValue();
            totalDocuments += documents.length;
            String[] stringArray = documents;
            int n = documents.length;
            int n2 = 0;
            while (n2 < n) {
                String document = stringArray[n2];
                if (category.equals(naiveBayesClassifier.classify(document))) {
                    ++rightDocuments;
                }
                ++n2;
            }
        }
        System.out.printf("\u51c6\u786e\u7387 %d / %d = %.2f%%\n\u901f\u5ea6 %.2f \u6587\u6863/\u79d2", rightDocuments, totalDocuments, (double)rightDocuments / (double)totalDocuments * 100.0, (double)totalDocuments / (double)(System.currentTimeMillis() - start) * 1000.0);
    }

    public void testPredict() throws Exception {
        NaiveBayesModel model = (NaiveBayesModel)IOUtil.readObjectFrom(MODEL_PATH);
        if (model == null) {
            this.testTrain();
            model = (NaiveBayesModel)IOUtil.readObjectFrom(MODEL_PATH);
        }
        NaiveBayesClassifier naiveBayesClassifier = new NaiveBayesClassifier(model);
        Map<String, Double> pMap = naiveBayesClassifier.predict("\u56fd\u5b892016\u8d5b\u5b63\u5e74\u7968\u5f00\u552e\u6bd4\u8d5b\u573a\u6b21\u51cf\u5c11\u5957\u7968\u5374\u4e0a\u6da8");
        for (Map.Entry<String, Double> entry : pMap.entrySet()) {
            System.out.println(entry);
        }
    }
}

