/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.corpus;

import com.hankcs.hanlp.classification.collections.FrequencyMap;
import com.hankcs.hanlp.classification.corpus.BagOfWordsDocument;
import com.hankcs.hanlp.classification.corpus.Catalog;
import com.hankcs.hanlp.classification.corpus.Lexicon;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class Document
extends BagOfWordsDocument {
    public int category;

    public Document(Catalog catalog, Lexicon lexicon, String category, String[] tokenArray) {
        assert (catalog != null);
        assert (lexicon != null);
        this.category = catalog.addCategory(category);
        int i = 0;
        while (i < tokenArray.length) {
            this.tfMap.add(lexicon.addWord(tokenArray[i]));
            ++i;
        }
    }

    public Document(ITrie<Integer> wordIdTrie, String[] tokenArray) {
        int i = 0;
        while (i < tokenArray.length) {
            Integer id = wordIdTrie.get(tokenArray[i].toCharArray());
            if (id != null) {
                this.tfMap.add(id);
            }
            ++i;
        }
    }

    public Document(Map<String, Integer> categoryId, BinTrie<Integer> wordId, String category, String[] tokenArray) {
        this(wordId, tokenArray);
        Integer id = categoryId.get(category);
        if (id == null) {
            id = -1;
        }
        this.category = id;
    }

    public Document(DataInputStream in) throws IOException {
        this.category = in.readInt();
        int size = in.readInt();
        this.tfMap = new FrequencyMap();
        int i = 0;
        while (i < size) {
            this.tfMap.put(in.readInt(), new int[]{in.readInt()});
            ++i;
        }
    }
}

