/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.corpus;

import com.hankcs.hanlp.classification.collections.FrequencyMap;
import com.hankcs.hanlp.classification.corpus.AbstractDataSet;
import com.hankcs.hanlp.classification.corpus.Document;
import com.hankcs.hanlp.classification.corpus.IDataSet;
import com.hankcs.hanlp.classification.models.AbstractModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileDataSet
extends AbstractDataSet {
    File cache;
    DataOutputStream out;
    int size;

    public FileDataSet(AbstractModel model, File cache) throws FileNotFoundException {
        super(model);
        this.initCache(cache);
    }

    public FileDataSet(AbstractModel model) throws IOException {
        this(model, File.createTempFile(String.valueOf(System.currentTimeMillis()), ".dat"));
    }

    public FileDataSet(File cache) throws FileNotFoundException {
        this.initCache(cache);
    }

    private void initCache(File cache) throws FileNotFoundException {
        this.cache = cache;
        this.out = new DataOutputStream(new FileOutputStream(cache));
    }

    private void initCache() throws IOException {
        this.initCache(File.createTempFile(String.valueOf(System.currentTimeMillis()), ".dat"));
    }

    public FileDataSet() throws IOException {
        this(File.createTempFile(String.valueOf(System.currentTimeMillis()), ".dat"));
    }

    @Override
    public Document add(String category, String text) {
        Document document = this.convert(category, text);
        try {
            this.add(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return document;
    }

    private void add(Document document) throws IOException {
        this.out.writeInt(document.category);
        Set entrySet = document.tfMap.entrySet();
        this.out.writeInt(entrySet.size());
        for (Map.Entry entry : entrySet) {
            this.out.writeInt((Integer)entry.getKey());
            this.out.writeInt(((int[])entry.getValue())[0]);
        }
        ++this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public IDataSet shrink(int[] idMap) {
        try {
            this.clear();
            Iterator<Document> iterator = this.iterator();
            this.initCache();
            while (iterator.hasNext()) {
                Document document = iterator.next();
                FrequencyMap<Integer> tfMap = new FrequencyMap<Integer>();
                for (Map.Entry entry : document.tfMap.entrySet()) {
                    Integer feature = (Integer)entry.getKey();
                    if (idMap[feature] == -1) continue;
                    tfMap.put(idMap[feature], (int[])entry.getValue());
                }
                if (tfMap.size() == 0) continue;
                document.tfMap = tfMap;
                this.add(document);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Iterator<Document> iterator() {
        try {
            this.out.close();
            final DataInputStream in = new DataInputStream(new FileInputStream(this.cache));
            return new Iterator<Document>(){

                @Override
                public void remove() {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
                }

                @Override
                public boolean hasNext() {
                    try {
                        boolean next;
                        boolean bl = next = in.available() > 0;
                        if (!next) {
                            in.close();
                        }
                        return next;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Document next() {
                    try {
                        return new Document(in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

