/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.corpus;

import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Lexicon {
    public BinTrie<Integer> wordId;
    public List<String> idWord;

    public Lexicon() {
        this.wordId = new BinTrie();
        this.idWord = new LinkedList<String>();
    }

    public Lexicon(BinTrie<Integer> wordIdTrie) {
        this.wordId = wordIdTrie;
    }

    public int addWord(String word) {
        assert (word != null);
        char[] charArray = word.toCharArray();
        Integer id = this.wordId.get(charArray);
        if (id == null) {
            id = this.wordId.size();
            this.wordId.put(charArray, id);
            this.idWord.add(word);
            assert (this.idWord.size() == this.wordId.size());
        }
        return id;
    }

    public Integer getId(String word) {
        return this.wordId.get(word);
    }

    public String getWord(int id) {
        assert (id >= 0);
        assert (id <= this.idWord.size());
        return this.idWord.get(id);
    }

    public int size() {
        return this.idWord.size();
    }

    public String[] getWordIdArray() {
        String[] wordIdArray = new String[this.idWord.size()];
        if (this.idWord.isEmpty()) {
            return wordIdArray;
        }
        int p = -1;
        Iterator<String> iterator = this.idWord.iterator();
        while (iterator.hasNext()) {
            wordIdArray[++p] = iterator.next();
        }
        return wordIdArray;
    }
}

