/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.utilities;

import java.util.Map;
import java.util.Set;

public class MathUtility {
    public static int sum(int ... var) {
        int sum = 0;
        int[] nArray = var;
        int n = var.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            sum += x;
            ++n2;
        }
        return sum;
    }

    public static double percentage(double current, double total) {
        return current / total * 100.0;
    }

    public static double average(double[] array) {
        double sum = 0.0;
        int i = 0;
        while (i < array.length) {
            sum += array[i];
            ++i;
        }
        return sum / (double)array.length;
    }

    public static void normalizeExp(Map<String, Double> predictionScores) {
        Set<Map.Entry<String, Double>> entrySet = predictionScores.entrySet();
        double max = Double.NEGATIVE_INFINITY;
        for (Map.Entry<String, Double> entry : entrySet) {
            max = Math.max(max, entry.getValue());
        }
        double sum = 0.0;
        for (Map.Entry<String, Double> entry : entrySet) {
            Double value = Math.exp(entry.getValue() - max);
            entry.setValue(value);
            sum += value.doubleValue();
        }
        if (sum != 0.0) {
            for (Map.Entry<String, Double> entry : entrySet) {
                predictionScores.put(entry.getKey(), entry.getValue() / sum);
            }
        }
    }

    public static void normalizeExp(double[] predictionScores) {
        double max = Double.NEGATIVE_INFINITY;
        double[] dArray = predictionScores;
        int n = predictionScores.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            max = Math.max(max, value);
            ++n2;
        }
        double sum = 0.0;
        int i = 0;
        while (i < predictionScores.length) {
            predictionScores[i] = Math.exp(predictionScores[i] - max);
            sum += predictionScores[i];
            ++i;
        }
        if (sum != 0.0) {
            i = 0;
            while (i < predictionScores.length) {
                int n3 = i++;
                predictionScores[n3] = predictionScores[n3] / sum;
            }
        }
    }
}

