/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.MDAG;

import com.hankcs.hanlp.collection.MDAG.MDAG;
import com.hankcs.hanlp.collection.MDAG.MDAGNode;
import com.hankcs.hanlp.collection.MDAG.SimpleMDAGNode;
import com.hankcs.hanlp.utility.ByteUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MDAGMap<V>
extends AbstractMap<String, V> {
    ArrayList<V> valueList = new ArrayList();
    MDAGForMap mdag = new MDAGForMap();

    @Override
    public V put(String key, V value) {
        V origin = this.get(key);
        if (origin == null) {
            this.valueList.add(value);
            char[] twoChar = ByteUtil.convertIntToTwoChar(this.valueList.size() - 1);
            this.mdag.addString(String.valueOf(key) + '\u0000' + twoChar[0] + twoChar[1]);
        }
        return origin;
    }

    @Override
    public V get(Object key) {
        int valueIndex = this.mdag.getValueIndex(key.toString());
        if (valueIndex != -1) {
            return this.valueList.get(valueIndex);
        }
        return null;
    }

    public V get(String key) {
        int valueIndex = this.mdag.getValueIndex(key);
        if (valueIndex != -1) {
            return this.valueList.get(valueIndex);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<String> keySet = this.mdag.getAllStrings();
        return null;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> stringSet = this.mdag.getAllStrings();
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (String key : stringSet) {
            keySet.add(key.substring(0, key.length() - 3));
        }
        return keySet;
    }

    public LinkedList<Map.Entry<String, V>> commonPrefixSearchWithValue(char[] key, int begin) {
        LinkedList<Map.Entry<String, Integer>> valueIndex = this.mdag.commonPrefixSearchWithValueIndex(key, begin);
        LinkedList<Map.Entry<String, V>> entryList = new LinkedList<Map.Entry<String, V>>();
        for (Map.Entry entry : valueIndex) {
            entryList.add(new AbstractMap.SimpleEntry<String, V>((String)entry.getKey(), this.valueList.get((Integer)entry.getValue())));
        }
        return entryList;
    }

    public LinkedList<Map.Entry<String, V>> commonPrefixSearchWithValue(String key) {
        return this.commonPrefixSearchWithValue(key.toCharArray(), 0);
    }

    public void simplify() {
        this.mdag.simplify();
    }

    public void unSimplify() {
        this.mdag.unSimplify();
    }

    static class MDAGForMap
    extends MDAG {
        static final char DELIMITER = '\u0000';

        MDAGForMap() {
        }

        public int getValueIndex(String key) {
            if (this.sourceNode != null) {
                MDAGNode currentNode = this.sourceNode.transition(key.toCharArray());
                if (currentNode == null) {
                    return -1;
                }
                return this.getValueIndex(currentNode);
            }
            SimpleMDAGNode currentNode = this.simplifiedSourceNode.transition(this.mdagDataArray, key.toCharArray());
            if (currentNode == null) {
                return -1;
            }
            return this.getValueIndex(currentNode);
        }

        private int getValueIndex(SimpleMDAGNode currentNode) {
            SimpleMDAGNode targetNode = currentNode.transition(this.mdagDataArray, '\u0000');
            if (targetNode == null) {
                return -1;
            }
            int transitionSetBeginIndex = targetNode.getTransitionSetBeginIndex();
            assert (targetNode.getOutgoingTransitionSetSize() == 1) : "\u4e0d\u662f\u5355\u94fe\uff01";
            char high = this.mdagDataArray[transitionSetBeginIndex].getLetter();
            targetNode = targetNode.transition(this.mdagDataArray, high);
            assert (targetNode.getOutgoingTransitionSetSize() == 1) : "\u4e0d\u662f\u5355\u94fe\uff01";
            transitionSetBeginIndex = targetNode.getTransitionSetBeginIndex();
            char low = this.mdagDataArray[transitionSetBeginIndex].getLetter();
            return ByteUtil.convertTwoCharToInt(high, low);
        }

        private int getValueIndex(MDAGNode currentNode) {
            MDAGNode targetNode = currentNode.transition('\u0000');
            if (targetNode == null) {
                return -1;
            }
            TreeMap<Character, MDAGNode> outgoingTransitions = targetNode.getOutgoingTransitions();
            assert (outgoingTransitions.size() == 1) : "\u4e0d\u662f\u5355\u94fe\uff01";
            char high = outgoingTransitions.keySet().iterator().next().charValue();
            targetNode = targetNode.transition(high);
            outgoingTransitions = targetNode.getOutgoingTransitions();
            assert (outgoingTransitions.size() == 1) : "\u4e0d\u662f\u5355\u94fe\uff01";
            char low = outgoingTransitions.keySet().iterator().next().charValue();
            return ByteUtil.convertTwoCharToInt(high, low);
        }

        public LinkedList<Map.Entry<String, Integer>> commonPrefixSearchWithValueIndex(char[] key, int begin) {
            LinkedList<Map.Entry<String, Integer>> result = new LinkedList<Map.Entry<String, Integer>>();
            if (this.sourceNode != null) {
                int charCount = key.length;
                MDAGNode currentNode = this.sourceNode;
                int i = 0;
                while (i < charCount) {
                    if ((currentNode = currentNode.transition(key[begin + i])) != null) {
                        int index = this.getValueIndex(currentNode);
                        if (index != -1) {
                            result.add(new AbstractMap.SimpleEntry<String, Integer>(new String(key, begin, i + 1), index));
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                int charCount = key.length;
                SimpleMDAGNode currentNode = this.simplifiedSourceNode;
                int i = 0;
                while (i < charCount) {
                    if ((currentNode = currentNode.transition(this.mdagDataArray, key[begin + i])) != null) {
                        int index = this.getValueIndex(currentNode);
                        if (index != -1) {
                            result.add(new AbstractMap.SimpleEntry<String, Integer>(new String(key, begin, i + 1), index));
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            return result;
        }
    }
}

