/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dartsclone.details;

import com.hankcs.hanlp.collection.dartsclone.details.AutoBytePool;
import com.hankcs.hanlp.collection.dartsclone.details.AutoIntPool;
import com.hankcs.hanlp.collection.dartsclone.details.DawgBuilder;
import com.hankcs.hanlp.collection.dartsclone.details.Keyset;

public class DoubleArrayBuilder {
    private static final int BLOCK_SIZE = 256;
    private static final int NUM_EXTRA_BLOCKS = 16;
    private static final int NUM_EXTRAS = 4096;
    private static final int UPPER_MASK = 534773760;
    private static final int LOWER_MASK = 255;
    private static final int OFFSET_MASK = -2147483137;
    private AutoIntPool _units = new AutoIntPool();
    private DoubleArrayBuilderExtraUnit[] _extras;
    private AutoBytePool _labels = new AutoBytePool();
    private int[] _table;
    private int _extrasHead;

    public void build(Keyset keyset) {
        if (keyset.hasValues()) {
            DawgBuilder dawgBuilder = new DawgBuilder();
            this.buildDawg(keyset, dawgBuilder);
            this.buildFromDawg(dawgBuilder);
            dawgBuilder.clear();
        } else {
            this.buildFromKeyset(keyset);
        }
    }

    public int[] copy() {
        int[] ret = new int[this._units.size()];
        System.arraycopy(this._units.getBuffer(), 0, ret, 0, this._units.size());
        return ret;
    }

    void clear() {
        this._units = null;
        this._extras = null;
        this._labels.clear();
        this._table = null;
        this._extrasHead = 0;
    }

    private int numBlocks() {
        return this._units.size() / 256;
    }

    private DoubleArrayBuilderExtraUnit extras(int id) {
        return this._extras[id % 4096];
    }

    private void buildDawg(Keyset keyset, DawgBuilder dawgBuilder) {
        dawgBuilder.init();
        int i = 0;
        while (i < keyset.numKeys()) {
            dawgBuilder.insert(keyset.getKey(i), keyset.getValue(i));
            ++i;
        }
        dawgBuilder.finish();
    }

    private void buildFromDawg(DawgBuilder dawg) {
        int numUnits = 1;
        while (numUnits < dawg.size()) {
            numUnits <<= 1;
        }
        this._units.reserve(numUnits);
        this._table = new int[dawg.numIntersections()];
        this._extras = new DoubleArrayBuilderExtraUnit[4096];
        int i = 0;
        while (i < this._extras.length) {
            this._extras[i] = new DoubleArrayBuilderExtraUnit();
            ++i;
        }
        this.reserveId(0);
        int[] units = this._units.getBuffer();
        units[0] = units[0] | 0x400;
        units[0] = units[0] & 0xFFFFFF00;
        if (dawg.child(dawg.root()) != 0) {
            this.buildFromDawg(dawg, dawg.root(), 0);
        }
        this.fixAllBlocks();
        this._extras = null;
        this._labels.clear();
        this._table = null;
    }

    private void buildFromDawg(DawgBuilder dawg, int dawgId, int dictId) {
        int dawgChildId = dawg.child(dawgId);
        if (dawg.isIntersection(dawgChildId)) {
            int intersectionId = dawg.intersectionId(dawgChildId);
            int offset = this._table[intersectionId];
            int[] units = this._units.getBuffer();
            if (offset != 0 && (((offset ^= dictId) & 0x1FE00000) == 0 || (offset & 0xFF) == 0)) {
                if (dawg.isLeaf(dawgChildId)) {
                    int n = dictId;
                    units[n] = units[n] | 0x100;
                }
                int n = dictId;
                units[n] = units[n] & 0x800001FF;
                int n2 = dictId;
                units[n2] = units[n2] | (offset < 0x200000 ? offset << 10 : offset << 2 | 0x200);
                return;
            }
        }
        int offset = this.arrangeFromDawg(dawg, dawgId, dictId);
        if (dawg.isIntersection(dawgChildId)) {
            this._table[dawg.intersectionId((int)dawgChildId)] = offset;
        }
        do {
            byte childLabel = dawg.label(dawgChildId);
            int dictChildId = offset ^ childLabel & 0xFF;
            if (childLabel == 0) continue;
            this.buildFromDawg(dawg, dawgChildId, dictChildId);
        } while ((dawgChildId = dawg.sibling(dawgChildId)) != 0);
    }

    private int arrangeFromDawg(DawgBuilder dawg, int dawgId, int dictId) {
        this._labels.resize(0);
        int dawgChildId = dawg.child(dawgId);
        while (dawgChildId != 0) {
            this._labels.add(dawg.label(dawgChildId));
            dawgChildId = dawg.sibling(dawgChildId);
        }
        int offset = this.findValidOffset(dictId);
        int[] units = this._units.getBuffer();
        int n = dictId;
        units[n] = units[n] & 0x800001FF;
        int newId = dictId ^ offset;
        int n2 = dictId;
        units[n2] = units[n2] | (newId < 0x200000 ? newId << 10 : newId << 2 | 0x200);
        dawgChildId = dawg.child(dawgId);
        int i = 0;
        while (i < this._labels.size()) {
            int dictChildId = offset ^ this._labels.get(i) & 0xFF;
            this.reserveId(dictChildId);
            units = this._units.getBuffer();
            if (dawg.isLeaf(dawgChildId)) {
                int n3 = dictId;
                units[n3] = units[n3] | 0x100;
                units[dictChildId] = dawg.value(dawgChildId) | Integer.MIN_VALUE;
            } else {
                units[dictChildId] = units[dictChildId] & 0xFFFFFF00 | this._labels.get(i) & 0xFF;
            }
            dawgChildId = dawg.sibling(dawgChildId);
            ++i;
        }
        this.extras((int)offset).isUsed = true;
        return offset;
    }

    private void buildFromKeyset(Keyset keyset) {
        int numUnits = 1;
        while (numUnits < keyset.numKeys()) {
            numUnits <<= 1;
        }
        this._units.reserve(numUnits);
        this._extras = new DoubleArrayBuilderExtraUnit[4096];
        int i = 0;
        while (i < this._extras.length) {
            this._extras[i] = new DoubleArrayBuilderExtraUnit();
            ++i;
        }
        this.reserveId(0);
        this.extras((int)0).isUsed = true;
        int[] units = this._units.getBuffer();
        units[0] = units[0] | 0x400;
        units[0] = units[0] & 0xFFFFFF00;
        if (keyset.numKeys() > 0) {
            this.buildFromKeyset(keyset, 0, keyset.numKeys(), 0, 0);
        }
        this.fixAllBlocks();
        this._extras = null;
        this._labels.clear();
    }

    private void buildFromKeyset(Keyset keyset, int begin, int end, int depth, int dicId) {
        int offset = this.arrangeFromKeyset(keyset, begin, end, depth, dicId);
        while (begin < end) {
            if (keyset.getKeyByte(begin, depth) != 0) break;
            ++begin;
        }
        if (begin == end) {
            return;
        }
        int lastBegin = begin;
        byte lastLabel = keyset.getKeyByte(begin, depth);
        while (++begin < end) {
            byte label = keyset.getKeyByte(begin, depth);
            if (label == lastLabel) continue;
            this.buildFromKeyset(keyset, lastBegin, begin, depth + 1, offset ^ lastLabel & 0xFF);
            lastBegin = begin;
            lastLabel = keyset.getKeyByte(begin, depth);
        }
        this.buildFromKeyset(keyset, lastBegin, end, depth + 1, offset ^ lastLabel & 0xFF);
    }

    private int arrangeFromKeyset(Keyset keyset, int begin, int end, int depth, int dictId) {
        this._labels.resize(0);
        int value = -1;
        int i = begin;
        while (i < end) {
            byte label = keyset.getKeyByte(i, depth);
            if (label == 0) {
                if (depth < keyset.getKey(i).length) {
                    throw new IllegalArgumentException("failed to build double-array: invalid null character");
                }
                if (keyset.getValue(i) < 0) {
                    throw new IllegalArgumentException("failed to build double-array: negative value");
                }
                if (value == -1) {
                    value = keyset.getValue(i);
                }
            }
            if (this._labels.empty()) {
                this._labels.add(label);
            } else if (label != this._labels.get(this._labels.size() - 1)) {
                if ((label & 0xFF) < (this._labels.get(this._labels.size() - 1) & 0xFF)) {
                    throw new IllegalArgumentException("failed to build double-array: wrong key order");
                }
                this._labels.add(label);
            }
            ++i;
        }
        int offset = this.findValidOffset(dictId);
        int[] units = this._units.getBuffer();
        int n = dictId;
        units[n] = units[n] & 0x800001FF;
        int newId = dictId ^ offset;
        int n2 = dictId;
        units[n2] = units[n2] | (newId < 0x200000 ? newId << 10 : newId << 2 | 0x200);
        int i2 = 0;
        while (i2 < this._labels.size()) {
            int dictChildId = offset ^ this._labels.get(i2) & 0xFF;
            this.reserveId(dictChildId);
            units = this._units.getBuffer();
            if (this._labels.get(i2) == 0) {
                int n3 = dictId;
                units[n3] = units[n3] | 0x100;
                units[dictChildId] = value | Integer.MIN_VALUE;
            } else {
                units[dictChildId] = units[dictChildId] & 0xFFFFFF00 | this._labels.get(i2) & 0xFF;
            }
            ++i2;
        }
        this.extras((int)offset).isUsed = true;
        return offset;
    }

    int findValidOffset(int id) {
        if (this._extrasHead >= this._units.size()) {
            return this._units.size() | id & 0xFF;
        }
        int unfixedId = this._extrasHead;
        do {
            int offset;
            if (!this.isValidOffset(id, offset = unfixedId ^ this._labels.get(0) & 0xFF)) continue;
            return offset;
        } while ((unfixedId = this.extras((int)unfixedId).next) != this._extrasHead);
        return this._units.size() | id & 0xFF;
    }

    boolean isValidOffset(int id, int offset) {
        if (this.extras((int)offset).isUsed) {
            return false;
        }
        int relOffset = id ^ offset;
        if ((relOffset & 0xFF) != 0 && (relOffset & 0x1FE00000) != 0) {
            return false;
        }
        int i = 1;
        while (i < this._labels.size()) {
            if (this.extras((int)(offset ^ this._labels.get((int)i) & 0xFF)).isFixed) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void reserveId(int id) {
        if (id >= this._units.size()) {
            this.expandUnits();
        }
        if (id == this._extrasHead) {
            this._extrasHead = this.extras((int)id).next;
            if (this._extrasHead == id) {
                this._extrasHead = this._units.size();
            }
        }
        this.extras((int)this.extras((int)id).prev).next = this.extras((int)id).next;
        this.extras((int)this.extras((int)id).next).prev = this.extras((int)id).prev;
        this.extras((int)id).isFixed = true;
    }

    void expandUnits() {
        int srcNumUnits = this._units.size();
        int srcNumBlocks = this.numBlocks();
        int destNumUnits = srcNumUnits + 256;
        int destNumBlocks = srcNumBlocks + 1;
        if (destNumBlocks > 16) {
            this.fixBlock(srcNumBlocks - 16);
        }
        this._units.resize(destNumUnits);
        if (destNumBlocks > 16) {
            int id = srcNumUnits;
            while (id < destNumUnits) {
                this.extras((int)id).isUsed = false;
                this.extras((int)id).isFixed = false;
                ++id;
            }
        }
        int i = srcNumUnits + 1;
        while (i < destNumUnits) {
            this.extras((int)(i - 1)).next = i;
            this.extras((int)i).prev = i - 1;
            ++i;
        }
        this.extras((int)srcNumUnits).prev = destNumUnits - 1;
        this.extras((int)(destNumUnits - 1)).next = srcNumUnits;
        this.extras((int)srcNumUnits).prev = this.extras((int)this._extrasHead).prev;
        this.extras((int)(destNumUnits - 1)).next = this._extrasHead;
        this.extras((int)this.extras((int)this._extrasHead).prev).next = srcNumUnits;
        this.extras((int)this._extrasHead).prev = destNumUnits - 1;
    }

    void fixAllBlocks() {
        int begin = 0;
        if (this.numBlocks() > 16) {
            begin = this.numBlocks() - 16;
        }
        int end = this.numBlocks();
        int blockId = begin;
        while (blockId != end) {
            this.fixBlock(blockId);
            ++blockId;
        }
    }

    void fixBlock(int blockId) {
        int begin = blockId * 256;
        int end = begin + 256;
        int unusedOffset = 0;
        int offset = begin;
        while (offset != end) {
            if (!this.extras((int)offset).isUsed) {
                unusedOffset = offset;
                break;
            }
            ++offset;
        }
        int id = begin;
        while (id != end) {
            if (!this.extras((int)id).isFixed) {
                this.reserveId(id);
                int[] units = this._units.getBuffer();
                units[id] = units[id] & 0xFFFFFF00 | (id ^ unusedOffset) & 0xFF;
            }
            ++id;
        }
    }

    static class DoubleArrayBuilderExtraUnit {
        int prev;
        int next;
        boolean isFixed;
        boolean isUsed;

        DoubleArrayBuilderExtraUnit() {
        }
    }
}

