/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.trie.bintrie;

import com.hankcs.hanlp.collection.trie.bintrie.Node;
import com.hankcs.hanlp.collection.trie.bintrie._ValueArray;
import com.hankcs.hanlp.corpus.io.ByteArray;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

public abstract class BaseNode<V>
implements Comparable<BaseNode> {
    static final Status[] ARRAY_STATUS = Status.values();
    protected BaseNode[] child;
    protected Status status;
    protected char c;
    protected V value;

    public BaseNode<V> transition(char[] path, int begin) {
        BaseNode cur = this;
        int i = begin;
        while (i < path.length) {
            if ((cur = cur.getChild(path[i])) == null || cur.status == Status.UNDEFINED_0) {
                return null;
            }
            ++i;
        }
        return cur;
    }

    protected abstract boolean addChild(BaseNode var1);

    protected boolean hasChild(char c) {
        return this.getChild(c) != null;
    }

    protected char getChar() {
        return this.c;
    }

    public abstract BaseNode getChild(char var1);

    public final V getValue() {
        return this.value;
    }

    public final void setValue(V value) {
        this.value = value;
    }

    @Override
    public int compareTo(BaseNode other) {
        return this.compareTo(other.getChar());
    }

    @Override
    public int compareTo(char other) {
        if (this.c > other) {
            return 1;
        }
        if (this.c < other) {
            return -1;
        }
        return 0;
    }

    public Status getStatus() {
        return this.status;
    }

    protected void walk(StringBuilder sb, Set<Map.Entry<String, V>> entrySet) {
        sb.append(this.c);
        if (this.status == Status.WORD_MIDDLE_2 || this.status == Status.WORD_END_3) {
            entrySet.add(new TrieEntry(sb.toString(), this.value));
        }
        if (this.child == null) {
            return;
        }
        BaseNode[] baseNodeArray = this.child;
        int n = this.child.length;
        int n2 = 0;
        while (n2 < n) {
            BaseNode node = baseNodeArray[n2];
            if (node != null) {
                node.walk(new StringBuilder(sb.toString()), entrySet);
            }
            ++n2;
        }
    }

    protected void walkToSave(DataOutputStream out) throws IOException {
        out.writeChar(this.c);
        out.writeInt(this.status.ordinal());
        int childSize = 0;
        if (this.child != null) {
            childSize = this.child.length;
        }
        out.writeInt(childSize);
        if (this.child == null) {
            return;
        }
        BaseNode[] baseNodeArray = this.child;
        int n = this.child.length;
        int n2 = 0;
        while (n2 < n) {
            BaseNode node = baseNodeArray[n2];
            node.walkToSave(out);
            ++n2;
        }
    }

    protected void walkToSave(ObjectOutput out) throws IOException {
        out.writeChar(this.c);
        out.writeInt(this.status.ordinal());
        if (this.status == Status.WORD_END_3 || this.status == Status.WORD_MIDDLE_2) {
            out.writeObject(this.value);
        }
        int childSize = 0;
        if (this.child != null) {
            childSize = this.child.length;
        }
        out.writeInt(childSize);
        if (this.child == null) {
            return;
        }
        BaseNode[] baseNodeArray = this.child;
        int n = this.child.length;
        int n2 = 0;
        while (n2 < n) {
            BaseNode node = baseNodeArray[n2];
            node.walkToSave(out);
            ++n2;
        }
    }

    protected void walkToLoad(ByteArray byteArray, _ValueArray<V> valueArray) {
        this.c = byteArray.nextChar();
        this.status = ARRAY_STATUS[byteArray.nextInt()];
        if (this.status == Status.WORD_END_3 || this.status == Status.WORD_MIDDLE_2) {
            this.value = valueArray.nextValue();
        }
        int childSize = byteArray.nextInt();
        this.child = new BaseNode[childSize];
        int i = 0;
        while (i < childSize) {
            this.child[i] = new Node();
            this.child[i].walkToLoad(byteArray, valueArray);
            ++i;
        }
    }

    protected void walkToLoad(ObjectInput byteArray) throws IOException, ClassNotFoundException {
        this.c = byteArray.readChar();
        this.status = ARRAY_STATUS[byteArray.readInt()];
        if (this.status == Status.WORD_END_3 || this.status == Status.WORD_MIDDLE_2) {
            this.value = byteArray.readObject();
        }
        int childSize = byteArray.readInt();
        this.child = new BaseNode[childSize];
        int i = 0;
        while (i < childSize) {
            this.child[i] = new Node();
            this.child[i].walkToLoad(byteArray);
            ++i;
        }
    }

    public String toString() {
        return "BaseNode{child=" + this.child.length + ", status=" + (Object)((Object)this.status) + ", c=" + this.c + ", value=" + this.value + '}';
    }

    public static enum Status {
        UNDEFINED_0,
        NOT_WORD_1,
        WORD_MIDDLE_2,
        WORD_END_3;

    }

    public class TrieEntry
    extends AbstractMap.SimpleEntry<String, V>
    implements Comparable<TrieEntry> {
        public TrieEntry(String key, V value) {
            super(key, value);
        }

        @Override
        public int compareTo(TrieEntry o) {
            return ((String)this.getKey()).compareTo((String)o.getKey());
        }
    }
}

