/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.corpus.dictionary.TFDictionary;
import com.hankcs.hanlp.corpus.occurrence.TermFrequency;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import java.util.ArrayList;
import java.util.List;

public class CommonSuffixExtractor {
    TFDictionary tfDictionary = new TFDictionary();

    public void add(String key) {
        this.tfDictionary.add(key);
    }

    public List<String> extractSuffixExtended(int length, int size) {
        return this.extractSuffix(length, size, true);
    }

    public List<String> extractSuffix(int length, int size, boolean extend) {
        TFDictionary suffixTreeSet = new TFDictionary();
        for (String key : this.tfDictionary.keySet()) {
            if (key.length() <= length) continue;
            suffixTreeSet.add(key.substring(key.length() - length, key.length()));
            if (!extend) continue;
            int l = 1;
            while (l < length) {
                suffixTreeSet.add(key.substring(key.length() - l, key.length()));
                ++l;
            }
        }
        if (extend) {
            size *= length;
        }
        return CommonSuffixExtractor.extract(suffixTreeSet, size);
    }

    private static List<String> extract(TFDictionary suffixTreeSet, int size) {
        ArrayList<String> suffixList = new ArrayList<String>(size);
        for (TermFrequency termFrequency : suffixTreeSet.values()) {
            if (suffixList.size() >= size) break;
            suffixList.add((String)termFrequency.getKey());
        }
        return suffixList;
    }

    public List<String> extractSuffixByWords(int length, int size, boolean extend) {
        TFDictionary suffixTreeSet = new TFDictionary();
        for (String key : this.tfDictionary.keySet()) {
            List<Term> termList = StandardTokenizer.segment(key);
            if (termList.size() <= length) continue;
            suffixTreeSet.add(CommonSuffixExtractor.combine(termList.subList(termList.size() - length, termList.size())));
            if (!extend) continue;
            int l = 1;
            while (l < length) {
                suffixTreeSet.add(CommonSuffixExtractor.combine(termList.subList(termList.size() - l, termList.size())));
                ++l;
            }
        }
        return CommonSuffixExtractor.extract(suffixTreeSet, size);
    }

    private static String combine(List<Term> termList) {
        StringBuilder sbResult = new StringBuilder();
        for (Term term : termList) {
            sbResult.append(term.word);
        }
        return sbResult.toString();
    }
}

