/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EasyDictionary {
    DoubleArrayTrie<Attribute> trie = new DoubleArrayTrie();

    public static EasyDictionary create(String path) {
        EasyDictionary dictionary = new EasyDictionary();
        if (dictionary.load(path)) {
            return dictionary;
        }
        Predefine.logger.warning("\u4ece" + path + "\u8bfb\u53d6\u5931\u8d25");
        return null;
    }

    private boolean load(String path) {
        Predefine.logger.info("\u901a\u7528\u8bcd\u5178\u5f00\u59cb\u52a0\u8f7d:" + path);
        ArrayList<String> wordList = new ArrayList<String>();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(HanLP.Config.IOAdapter == null ? new FileInputStream(path) : HanLP.Config.IOAdapter.open(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                String[] param = line.split(" ");
                wordList.add(param[0]);
                int natureCount = (param.length - 1) / 2;
                Attribute attribute = new Attribute(natureCount);
                int i = 0;
                while (i < natureCount) {
                    attribute.nature[i] = Enum.valueOf(Nature.class, param[1 + 2 * i]);
                    attribute.frequency[i] = Integer.parseInt(param[2 + 2 * i]);
                    attribute.totalFrequency += attribute.frequency[i];
                    ++i;
                }
                attributeList.add(attribute);
            }
            Predefine.logger.info("\u901a\u7528\u8bcd\u5178\u8bfb\u5165\u8bcd\u6761" + wordList.size() + " \u5c5e\u6027" + attributeList.size());
            br.close();
        }
        catch (FileNotFoundException e) {
            Predefine.logger.severe("\u901a\u7528\u8bcd\u5178" + path + "\u4e0d\u5b58\u5728\uff01" + e);
            return false;
        }
        catch (IOException e) {
            Predefine.logger.severe("\u901a\u7528\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        Predefine.logger.info("\u901a\u7528\u8bcd\u5178DAT\u6784\u5efa\u7ed3\u679c:" + this.trie.build(wordList, attributeList));
        Predefine.logger.info("\u901a\u7528\u8bcd\u5178\u52a0\u8f7d\u6210\u529f:" + this.trie.size() + "\u4e2a\u8bcd\u6761");
        return true;
    }

    public Attribute GetWordInfo(String key) {
        return this.trie.get(key);
    }

    public boolean contains(String key) {
        return this.GetWordInfo(key) != null;
    }

    public BaseSearcher getSearcher(String text) {
        return new Searcher(text);
    }

    public static class Attribute {
        public Nature[] nature;
        public int[] frequency;
        public int totalFrequency;

        public Attribute(int size) {
            this.nature = new Nature[size];
            this.frequency = new int[size];
        }

        public Attribute(Nature[] nature, int[] frequency) {
            this.nature = nature;
            this.frequency = frequency;
        }

        public Attribute(Nature nature, int frequency) {
            this(1);
            this.nature[0] = nature;
            this.frequency[0] = frequency;
            this.totalFrequency = frequency;
        }

        public Attribute(Nature nature) {
            this(nature, 1000);
        }

        public int getNatureFrequency(String nature) {
            try {
                Nature pos = Enum.valueOf(Nature.class, nature);
                return this.getNatureFrequency(pos);
            }
            catch (IllegalArgumentException e) {
                return 0;
            }
        }

        public int getNatureFrequency(Nature nature) {
            int result = 0;
            int i = 0;
            Nature[] natureArray = this.nature;
            int n = this.nature.length;
            int n2 = 0;
            while (n2 < n) {
                Nature pos = natureArray[n2];
                if (nature == pos) {
                    return this.frequency[i];
                }
                ++i;
                ++n2;
            }
            return result;
        }

        public String toString() {
            return "Attribute{nature=" + Arrays.toString((Object[])this.nature) + ", frequency=" + Arrays.toString(this.frequency) + '}';
        }
    }

    public class Searcher
    extends BaseSearcher<Attribute> {
        int begin;
        private List<Map.Entry<String, Attribute>> entryList;

        protected Searcher(char[] c) {
            super(c);
        }

        protected Searcher(String text) {
            super(text);
            this.entryList = new LinkedList<Map.Entry<String, Attribute>>();
        }

        @Override
        public Map.Entry<String, Attribute> next() {
            while (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = EasyDictionary.this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = EasyDictionary.this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0) {
                return null;
            }
            Map.Entry<String, Attribute> result = this.entryList.get(0);
            this.entryList.remove(0);
            this.offset = this.begin - 1;
            return result;
        }
    }
}

