/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary.item;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class EnumItem<E extends Enum<E>> {
    public Map<E, Integer> labelMap = new TreeMap<E, Integer>();

    public EnumItem() {
    }

    public EnumItem(E label, Integer frequency) {
        this();
        this.labelMap.put(label, frequency);
    }

    public EnumItem(E ... labels) {
        this();
        E[] EArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            E label = EArray[n2];
            this.labelMap.put(label, 1);
            ++n2;
        }
    }

    public void addLabel(E label) {
        Integer frequency = this.labelMap.get(label);
        frequency = frequency == null ? Integer.valueOf(1) : Integer.valueOf(frequency + 1);
        this.labelMap.put(label, frequency);
    }

    public void addLabel(E label, Integer frequency) {
        Integer innerFrequency = this.labelMap.get(label);
        innerFrequency = innerFrequency == null ? frequency : Integer.valueOf(innerFrequency + frequency);
        this.labelMap.put(label, innerFrequency);
    }

    public boolean containsLabel(E label) {
        return this.labelMap.containsKey(label);
    }

    public int getFrequency(E label) {
        Integer frequency = this.labelMap.get(label);
        if (frequency == null) {
            return 0;
        }
        return frequency;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<E, Integer>> entries = new ArrayList<Map.Entry<E, Integer>>(this.labelMap.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<E, Integer>>(){

            @Override
            public int compare(Map.Entry<E, Integer> o1, Map.Entry<E, Integer> o2) {
                return -o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry<E, Integer> entry : entries) {
            sb.append(entry.getKey());
            sb.append(' ');
            sb.append(entry.getValue());
            sb.append(' ');
        }
        return sb.toString();
    }

    public static Map.Entry<String, Map.Entry<String, Integer>[]> create(String param) {
        if (param == null) {
            return null;
        }
        String[] array = param.split(" ");
        return EnumItem.create(array);
    }

    public static Map.Entry<String, Map.Entry<String, Integer>[]> create(String[] param) {
        if (param.length % 2 == 0) {
            return null;
        }
        int natureCount = (param.length - 1) / 2;
        Map.Entry[] entries = (Map.Entry[])Array.newInstance(Map.Entry.class, natureCount);
        int i = 0;
        while (i < natureCount) {
            entries[i] = new AbstractMap.SimpleEntry<String, Integer>(param[1 + 2 * i], Integer.parseInt(param[2 + 2 * i]));
            ++i;
        }
        return new AbstractMap.SimpleEntry<String, Map.Entry<String, Integer>[]>(param[0], entries);
    }
}

