/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.document.sentence.word;

import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.utility.Predefine;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CompoundWord
implements IWord,
Iterable<Word> {
    public List<Word> innerList;
    public String label;

    @Override
    public String getValue() {
        StringBuilder sb = new StringBuilder();
        for (Word word : this.innerList) {
            sb.append(word.value);
        }
        return sb.toString();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setValue(String value) {
        this.innerList.clear();
        this.innerList.add(new Word(value, this.label));
    }

    @Override
    public int length() {
        return this.getValue().length();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 1;
        for (Word word : this.innerList) {
            sb.append(word.toString());
            if (i != this.innerList.size()) {
                sb.append(' ');
            }
            ++i;
        }
        sb.append("]/");
        sb.append(this.label);
        return sb.toString();
    }

    public Word toWord() {
        return new Word(this.getValue(), this.getLabel());
    }

    public CompoundWord(List<Word> innerList, String label) {
        this.innerList = innerList;
        this.label = label;
    }

    public static CompoundWord create(String param) {
        if (param == null) {
            return null;
        }
        int cutIndex = param.lastIndexOf(93);
        if (cutIndex <= 2 || cutIndex == param.length() - 1) {
            return null;
        }
        String wordParam = param.substring(1, cutIndex);
        LinkedList<Word> wordList = new LinkedList<Word>();
        String[] stringArray = wordParam.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String single = stringArray[n2];
            if (single.length() != 0) {
                Word word = Word.create(single);
                if (word == null) {
                    Predefine.logger.warning("\u4f7f\u7528\u53c2\u6570" + single + "\u6784\u9020\u5355\u8bcd\u65f6\u53d1\u751f\u9519\u8bef");
                    return null;
                }
                wordList.add(word);
            }
            ++n2;
        }
        String labelParam = param.substring(cutIndex + 1);
        if (labelParam.startsWith("/")) {
            labelParam = labelParam.substring(1);
        }
        return new CompoundWord(wordList, labelParam);
    }

    @Override
    public Iterator<Word> iterator() {
        return this.innerList.iterator();
    }
}

