/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.io;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.utility.LexiconUtility;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class IOUtil {
    public static boolean saveObjectTo(Object o, String path) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(IOUtil.newOutputStream(path));
            oos.writeObject(o);
            oos.close();
        }
        catch (IOException e) {
            Predefine.logger.warning("\u5728\u4fdd\u5b58\u5bf9\u8c61" + o + "\u5230" + path + "\u65f6\u53d1\u751f\u5f02\u5e38" + e);
            return false;
        }
        return true;
    }

    public static Object readObjectFrom(String path) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(IOUtil.newInputStream(path));
            Object o = ois.readObject();
            ois.close();
            return o;
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5728\u4ece" + path + "\u8bfb\u53d6\u5bf9\u8c61\u65f6\u53d1\u751f\u5f02\u5e38" + e);
            return null;
        }
    }

    public static String readTxt(String path) {
        if (path == null) {
            return null;
        }
        try {
            InputStream in = HanLP.Config.IOAdapter == null ? new FileInputStream(path) : HanLP.Config.IOAdapter.open(path);
            byte[] fileContent = new byte[in.available()];
            IOUtil.readBytesFromOtherInputStream(in, fileContent);
            in.close();
            if (fileContent[0] == -17 && fileContent[1] == -69 && fileContent[2] == -65) {
                return new String(fileContent, 3, fileContent.length - 3, Charset.forName("UTF-8"));
            }
            return new String(fileContent, Charset.forName("UTF-8"));
        }
        catch (FileNotFoundException e) {
            Predefine.logger.warning("\u627e\u4e0d\u5230" + path + e);
            return null;
        }
        catch (IOException e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u53d1\u751fIO\u5f02\u5e38" + e);
            return null;
        }
    }

    public static LinkedList<String[]> readCsv(String path) {
        LinkedList<String[]> resultList = new LinkedList<String[]>();
        LinkedList<String> lineList = IOUtil.readLineList(path);
        for (String line : lineList) {
            resultList.add(line.split(","));
        }
        return resultList;
    }

    public static boolean saveTxt(String path, String content) {
        try {
            FileChannel fc = new FileOutputStream(path).getChannel();
            fc.write(ByteBuffer.wrap(content.getBytes()));
            fc.close();
        }
        catch (Exception e) {
            Predefine.logger.throwing("IOUtil", "saveTxt", e);
            Predefine.logger.warning("IOUtil saveTxt \u5230" + path + "\u5931\u8d25" + e.toString());
            return false;
        }
        return true;
    }

    public static boolean saveTxt(String path, StringBuilder content) {
        return IOUtil.saveTxt(path, content.toString());
    }

    public static <T> boolean saveCollectionToTxt(Collection<T> collection, String path) {
        StringBuilder sb = new StringBuilder();
        for (T o : collection) {
            sb.append(o);
            sb.append('\n');
        }
        return IOUtil.saveTxt(path, sb.toString());
    }

    public static byte[] readBytes(String path) {
        try {
            if (HanLP.Config.IOAdapter == null) {
                return IOUtil.readBytesFromFileInputStream(new FileInputStream(path));
            }
            InputStream is = HanLP.Config.IOAdapter.open(path);
            if (is instanceof FileInputStream) {
                return IOUtil.readBytesFromFileInputStream((FileInputStream)is);
            }
            return IOUtil.readBytesFromOtherInputStream(is);
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u65f6\u53d1\u751f\u5f02\u5e38" + e);
            return null;
        }
    }

    public static String readTxt(String file, String charsetName) throws IOException {
        int len;
        InputStream is = HanLP.Config.IOAdapter.open(file);
        byte[] targetArray = new byte[is.available()];
        int off = 0;
        while ((len = is.read(targetArray, off, targetArray.length - off)) != -1 && off < targetArray.length) {
            off += len;
        }
        is.close();
        return new String(targetArray, charsetName);
    }

    public static String baseName(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        path = path.replaceAll("[/\\\\]+", "/");
        int len = path.length();
        int upCount = 0;
        while (len > 0) {
            if (path.charAt(len - 1) == '/' && --len == 0) {
                return "";
            }
            int lastInd = path.lastIndexOf(47, len - 1);
            String fileName = path.substring(lastInd + 1, len);
            if (fileName.equals(".")) {
                --len;
                continue;
            }
            if (fileName.equals("..")) {
                len -= 2;
                ++upCount;
                continue;
            }
            if (upCount == 0) {
                return fileName;
            }
            --upCount;
            len -= fileName.length();
        }
        return "";
    }

    private static byte[] readBytesFromFileInputStream(FileInputStream fis) throws IOException {
        FileChannel channel = fis.getChannel();
        int fileSize = (int)channel.size();
        ByteBuffer byteBuffer = ByteBuffer.allocate(fileSize);
        channel.read(byteBuffer);
        byteBuffer.flip();
        byte[] bytes = byteBuffer.array();
        byteBuffer.clear();
        channel.close();
        fis.close();
        return bytes;
    }

    public static byte[] readBytesFromOtherInputStream(InputStream is) throws IOException {
        int readBytes;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[Math.max(is.available(), 4096)];
        while ((readBytes = is.read(buffer, 0, buffer.length)) != -1) {
            data.write(buffer, 0, readBytes);
        }
        data.flush();
        return data.toByteArray();
    }

    public static int readBytesFromOtherInputStream(InputStream is, byte[] targetArray) throws IOException {
        int len;
        assert (targetArray != null);
        assert (targetArray.length > 0);
        int off = 0;
        while (off < targetArray.length && (len = is.read(targetArray, off, targetArray.length - off)) != -1) {
            off += len;
        }
        return off;
    }

    public static LinkedList<String> readLineList(String path) {
        LinkedList<String> result = new LinkedList<String>();
        String txt = IOUtil.readTxt(path);
        if (txt == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(txt, "\n");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static LinkedList<String> readLineListWithLessMemory(String path) {
        LinkedList<String> result = new LinkedList<String>();
        String line = null;
        boolean first = true;
        try {
            BufferedReader bw = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            while ((line = bw.readLine()) != null) {
                if (first) {
                    first = false;
                    if (!line.isEmpty() && line.charAt(0) == '\ufeff') {
                        line = line.substring(1);
                    }
                }
                result.add(line);
            }
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u52a0\u8f7d" + path + "\u5931\u8d25\uff0c" + e);
        }
        return result;
    }

    public static boolean saveMapToTxt(Map<Object, Object> map, String path) {
        return IOUtil.saveMapToTxt(map, path, "=");
    }

    public static boolean saveMapToTxt(Map<Object, Object> map, String path, String separator) {
        map = new TreeMap<Object, Object>(map);
        return IOUtil.saveEntrySetToTxt(map.entrySet(), path, separator);
    }

    public static boolean saveEntrySetToTxt(Set<Map.Entry<Object, Object>> entrySet, String path, String separator) {
        StringBuilder sbOut = new StringBuilder();
        for (Map.Entry<Object, Object> entry : entrySet) {
            sbOut.append(entry.getKey());
            sbOut.append(separator);
            sbOut.append(entry.getValue());
            sbOut.append('\n');
        }
        return IOUtil.saveTxt(path, sbOut.toString());
    }

    public static String dirname(String path) {
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index + 1);
    }

    public static LineIterator readLine(String path) {
        return new LineIterator(path);
    }

    public static boolean deleteFile(String path) {
        return new File(path).delete();
    }

    public static BufferedWriter newBufferedWriter(String path) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.newOutputStream(path), "UTF-8"));
    }

    public static BufferedReader newBufferedReader(String path) throws IOException {
        return new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
    }

    public static BufferedWriter newBufferedWriter(String path, boolean append) throws FileNotFoundException, UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, append), "UTF-8"));
    }

    public static InputStream newInputStream(String path) throws IOException {
        if (HanLP.Config.IOAdapter == null) {
            return new FileInputStream(path);
        }
        return HanLP.Config.IOAdapter.open(path);
    }

    public static OutputStream newOutputStream(String path) throws IOException {
        if (HanLP.Config.IOAdapter == null) {
            return new FileOutputStream(path);
        }
        return HanLP.Config.IOAdapter.create(path);
    }

    public static String getSuffix(String name, String delimiter) {
        return name.substring(name.lastIndexOf(delimiter) + 1);
    }

    public static void writeLine(BufferedWriter bw, String ... params) throws IOException {
        int i = 0;
        while (i < params.length - 1) {
            bw.write(params[i]);
            bw.write(9);
            ++i;
        }
        bw.write(params[params.length - 1]);
    }

    public static TreeMap<String, CoreDictionary.Attribute> loadDictionary(String ... pathArray) throws IOException {
        TreeMap<String, CoreDictionary.Attribute> map = new TreeMap<String, CoreDictionary.Attribute>();
        String[] stringArray = pathArray;
        int n = pathArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            IOUtil.loadDictionary(br, map);
            ++n2;
        }
        return map;
    }

    public static void loadDictionary(BufferedReader br, TreeMap<String, CoreDictionary.Attribute> storage) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            String[] param = line.split("\\s");
            int natureCount = (param.length - 1) / 2;
            CoreDictionary.Attribute attribute = new CoreDictionary.Attribute(natureCount);
            int i = 0;
            while (i < natureCount) {
                attribute.nature[i] = LexiconUtility.convertStringToNature(param[1 + 2 * i]);
                attribute.frequency[i] = Integer.parseInt(param[2 + 2 * i]);
                attribute.totalFrequency += attribute.frequency[i];
                ++i;
            }
            storage.put(param[0], attribute);
        }
        br.close();
    }

    public static void writeCustomNature(DataOutputStream out, LinkedHashSet<Nature> customNatureCollector) throws IOException {
        if (customNatureCollector.size() == 0) {
            return;
        }
        out.writeInt(-customNatureCollector.size());
        for (Nature nature : customNatureCollector) {
            TextUtility.writeString(nature.toString(), out);
        }
    }

    public static boolean isFileExisted(String path) {
        File file = new File(path);
        return file.isFile() && file.exists();
    }

    public static class LineIterator
    implements Iterator<String> {
        BufferedReader bw;
        String line;

        public LineIterator(BufferedReader bw) {
            this.bw = bw;
        }

        public LineIterator(String path) {
            try {
                this.bw = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
                this.line = this.bw.readLine();
            }
            catch (FileNotFoundException e) {
                Predefine.logger.warning("\u6587\u4ef6" + path + "\u4e0d\u5b58\u5728\uff0c\u63a5\u4e0b\u6765\u7684\u8c03\u7528\u4f1a\u8fd4\u56denull\n" + TextUtility.exceptionToString(e));
                this.bw = null;
            }
            catch (IOException e) {
                Predefine.logger.warning("\u5728\u8bfb\u53d6\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
                this.bw = null;
            }
        }

        public void close() {
            if (this.bw == null) {
                return;
            }
            try {
                this.bw.close();
                this.bw = null;
            }
            catch (IOException e) {
                Predefine.logger.warning("\u5173\u95ed\u6587\u4ef6\u5931\u8d25" + TextUtility.exceptionToString(e));
            }
        }

        @Override
        public boolean hasNext() {
            if (this.bw == null) {
                return false;
            }
            if (this.line == null) {
                try {
                    this.bw.close();
                    this.bw = null;
                }
                catch (IOException e) {
                    Predefine.logger.warning("\u5173\u95ed\u6587\u4ef6\u5931\u8d25" + TextUtility.exceptionToString(e));
                }
                return false;
            }
            return true;
        }

        @Override
        public String next() {
            String preLine = this.line;
            try {
                if (this.bw != null) {
                    this.line = this.bw.readLine();
                    if (this.line == null && this.bw != null) {
                        try {
                            this.bw.close();
                            this.bw = null;
                        }
                        catch (IOException e) {
                            Predefine.logger.warning("\u5173\u95ed\u6587\u4ef6\u5931\u8d25" + TextUtility.exceptionToString(e));
                        }
                    }
                } else {
                    this.line = null;
                }
            }
            catch (IOException e) {
                Predefine.logger.warning("\u5728\u8bfb\u53d6\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
            }
            return preLine;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("\u53ea\u8bfb\uff0c\u4e0d\u53ef\u5199\uff01");
        }
    }
}

