/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dependency.AbstractDependencyParser;
import com.hankcs.hanlp.dependency.common.POSUtil;
import com.hankcs.hanlp.model.bigram.BigramDependencyModel;
import com.hankcs.hanlp.model.crf.CRFModel;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.Table;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.GlobalObjectPool;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CRFDependencyParser
extends AbstractDependencyParser {
    CRFModel crfModel;

    public CRFDependencyParser(String modelPath) {
        this.crfModel = (CRFModel)GlobalObjectPool.get(modelPath);
        if (this.crfModel != null) {
            return;
        }
        long start = System.currentTimeMillis();
        if (this.load(modelPath)) {
            Predefine.logger.info("\u52a0\u8f7d\u968f\u673a\u6761\u4ef6\u573a\u4f9d\u5b58\u53e5\u6cd5\u5206\u6790\u5668\u6a21\u578b" + modelPath + "\u6210\u529f\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms");
            GlobalObjectPool.put(modelPath, this.crfModel);
        } else {
            Predefine.logger.info("\u52a0\u8f7d\u968f\u673a\u6761\u4ef6\u573a\u4f9d\u5b58\u53e5\u6cd5\u5206\u6790\u5668\u6a21\u578b" + modelPath + "\u5931\u8d25\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public CRFDependencyParser() {
        this(HanLP.Config.CRFDependencyModelPath);
    }

    public static CoNLLSentence compute(List<Term> termList) {
        return new CRFDependencyParser().parse(termList);
    }

    public static CoNLLSentence compute(String sentence) {
        return new CRFDependencyParser().parse(sentence);
    }

    boolean load(String path) {
        if (this.loadDat(String.valueOf(path) + ".bin")) {
            return true;
        }
        this.crfModel = CRFModel.loadTxt(path, new CRFModelForDependency(new DoubleArrayTrie<FeatureFunction>()));
        return this.crfModel != null;
    }

    boolean loadDat(String path) {
        ByteArray byteArray = ByteArray.createByteArray(path);
        if (byteArray == null) {
            return false;
        }
        this.crfModel = new CRFModelForDependency(new DoubleArrayTrie<FeatureFunction>());
        return this.crfModel.load(byteArray);
    }

    boolean saveDat(String path) {
        try {
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(path));
            this.crfModel.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5728\u7f13\u5b58" + path + "\u65f6\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    @Override
    public CoNLLSentence parse(List<Term> termList) {
        Table table = new Table();
        table.v = new String[termList.size()][4];
        Iterator<Term> iterator = termList.iterator();
        String[][] stringArray = table.v;
        int n = table.v.length;
        int n2 = 0;
        while (n2 < n) {
            String[] line = stringArray[n2];
            Term term = iterator.next();
            line[0] = term.word;
            line[2] = POSUtil.compilePOS(term.nature);
            line[1] = line[2].substring(0, 1);
            ++n2;
        }
        this.crfModel.tag(table);
        if (HanLP.Config.DEBUG) {
            System.out.println(table);
        }
        CoNLLWord[] coNLLWordArray = new CoNLLWord[table.size()];
        int i = 0;
        while (i < coNLLWordArray.length) {
            coNLLWordArray[i] = new CoNLLWord(i + 1, table.v[i][0], table.v[i][2], table.v[i][1]);
            ++i;
        }
        i = 0;
        String[][] stringArray2 = table.v;
        int n3 = table.v.length;
        int n4 = 0;
        while (n4 < n3) {
            int index;
            String[] line = stringArray2[n4];
            CRFModelForDependency.DTag dTag = new CRFModelForDependency.DTag(line[3]);
            coNLLWordArray[i].HEAD = dTag.pos.endsWith("ROOT") ? CoNLLWord.ROOT : ((index = CRFDependencyParser.convertOffset2Index(dTag, table, i)) == -1 ? CoNLLWord.NULL : coNLLWordArray[index]);
            ++i;
            ++n4;
        }
        i = 0;
        while (i < coNLLWordArray.length) {
            coNLLWordArray[i].DEPREL = BigramDependencyModel.get(coNLLWordArray[i].NAME, coNLLWordArray[i].POSTAG, coNLLWordArray[i].HEAD.NAME, coNLLWordArray[i].HEAD.POSTAG);
            ++i;
        }
        return new CoNLLSentence(coNLLWordArray);
    }

    static int convertOffset2Index(CRFModelForDependency.DTag dTag, Table table, int current) {
        int posCount = 0;
        if (dTag.offset > 0) {
            int i = current + 1;
            while (i < table.size()) {
                if (table.v[i][1].equals(dTag.pos)) {
                    ++posCount;
                }
                if (posCount == dTag.offset) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = current - 1;
            while (i >= 0) {
                if (table.v[i][1].equals(dTag.pos)) {
                    ++posCount;
                }
                if (posCount == -dTag.offset) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    static class CRFModelForDependency
    extends CRFModel {
        DTag[] id2dtag;

        public CRFModelForDependency(ITrie<FeatureFunction> featureFunctionTrie) {
            super(featureFunctionTrie);
        }

        @Override
        public boolean load(ByteArray byteArray) {
            if (!super.load(byteArray)) {
                return false;
            }
            this.initId2dtagArray();
            return true;
        }

        private void initId2dtagArray() {
            this.id2dtag = new DTag[this.id2tag.length];
            int i = 0;
            while (i < this.id2tag.length) {
                this.id2dtag[i] = new DTag(this.id2tag[i]);
                ++i;
            }
        }

        @Override
        protected void onLoadTxtFinished() {
            super.onLoadTxtFinished();
            this.initId2dtagArray();
        }

        boolean isLegal(int tagId, int current, Table table) {
            DTag tag = this.id2dtag[tagId];
            if ("ROOT".equals(tag.pos)) {
                int i = 0;
                while (i < current) {
                    if (table.v[i][3].endsWith("ROOT")) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            int posCount = 0;
            if (tag.offset > 0) {
                int i = current + 1;
                while (i < table.size()) {
                    if (table.v[i][1].equals(tag.pos)) {
                        ++posCount;
                    }
                    if (posCount == tag.offset) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            int i = current - 1;
            while (i >= 0) {
                if (table.v[i][1].equals(tag.pos)) {
                    ++posCount;
                }
                if (posCount == -tag.offset) {
                    return true;
                }
                --i;
            }
            return false;
        }

        @Override
        public void tag(Table table) {
            int size = table.size();
            double bestScore = Double.MIN_VALUE;
            int bestTag = 0;
            int tagSize = this.id2tag.length;
            LinkedList<double[]> scoreList = this.computeScoreList(table, 0);
            int i = 0;
            while (i < tagSize) {
                int j = 0;
                while (j < tagSize) {
                    if (this.isLegal(j, 0, table)) {
                        double curScore = CRFModelForDependency.computeScore(scoreList, j);
                        if (this.matrix != null) {
                            curScore += this.matrix[i][j];
                        }
                        if (curScore > bestScore) {
                            bestScore = curScore;
                            bestTag = j;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            table.setLast(0, this.id2tag[bestTag]);
            int preTag = bestTag;
            int i2 = 1;
            while (i2 < size) {
                scoreList = this.computeScoreList(table, i2);
                bestScore = Double.MIN_VALUE;
                int j = 0;
                while (j < tagSize) {
                    if (this.isLegal(j, i2, table)) {
                        double curScore = CRFModelForDependency.computeScore(scoreList, j);
                        if (this.matrix != null) {
                            curScore += this.matrix[preTag][j];
                        }
                        if (curScore > bestScore) {
                            bestScore = curScore;
                            bestTag = j;
                        }
                    }
                    ++j;
                }
                table.setLast(i2, this.id2tag[bestTag]);
                preTag = bestTag;
                ++i2;
            }
        }

        static class DTag {
            int offset;
            String pos;

            public DTag(String tag) {
                String[] args = tag.split("_", 2);
                if (args[0].charAt(0) == '+') {
                    args[0] = args[0].substring(1);
                }
                this.offset = Integer.parseInt(args[0]);
                this.pos = args[1];
            }

            public String toString() {
                return String.valueOf(this.offset > 0 ? "+" : "") + this.offset + "_" + this.pos;
            }
        }
    }
}

