/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.nnparser;

import com.hankcs.hanlp.dependency.nnparser.State;
import com.hankcs.hanlp.dependency.nnparser.action.Action;
import com.hankcs.hanlp.dependency.nnparser.action.ActionFactory;
import com.hankcs.hanlp.dependency.nnparser.action.ActionUtils;
import java.util.ArrayList;
import java.util.List;

public class TransitionSystem {
    int L = 0;
    int R = -1;
    int D = -1;

    void set_root_relation(int r) {
        this.R = r;
    }

    void set_number_of_relations(int l) {
        this.L = l;
    }

    void get_possible_actions(State source, List<Action> actions) {
        if (this.L == 0 || -1 == this.R) {
            System.err.println("decoder: not initialized, please check if the root dependency relation is correct set by --root.");
            return;
        }
        actions.clear();
        if (!source.buffer_empty()) {
            actions.add(ActionFactory.make_shift());
        }
        if (source.stack_size() == 2) {
            if (source.buffer_empty()) {
                actions.add(ActionFactory.make_right_arc(this.R));
            }
        } else if (source.stack_size() > 2) {
            int l = 0;
            while (l < this.L) {
                if (l != this.R) {
                    actions.add(ActionFactory.make_left_arc(l));
                    actions.add(ActionFactory.make_right_arc(l));
                }
                ++l;
            }
        }
    }

    void transit(State source, Action act, State target) {
        int deprel = 0;
        int[] deprel_inference = new int[]{deprel};
        if (ActionUtils.is_shift(act)) {
            target.shift(source);
        } else if (ActionUtils.is_left_arc(act, deprel_inference)) {
            deprel = deprel_inference[0];
            target.left_arc(source, deprel);
        } else if (ActionUtils.is_right_arc(act, deprel_inference)) {
            deprel = deprel_inference[0];
            target.right_arc(source, deprel);
        } else {
            System.err.printf("unknown transition in transit: %d-%d", act.name(), act.rel());
        }
    }

    List<Integer> transform(List<Action> actions) {
        ArrayList<Integer> classes = new ArrayList<Integer>();
        this.transform(actions, classes);
        return classes;
    }

    void transform(List<Action> actions, List<Integer> classes) {
        classes.clear();
        int i = 0;
        while (i < actions.size()) {
            classes.add(this.transform(actions.get(i)));
            ++i;
        }
    }

    int transform(Action act) {
        int deprel = 0;
        int[] deprel_inference = new int[]{deprel};
        if (ActionUtils.is_shift(act)) {
            return 0;
        }
        if (ActionUtils.is_left_arc(act, deprel_inference)) {
            deprel = deprel_inference[0];
            return 1 + deprel;
        }
        if (ActionUtils.is_right_arc(act, deprel_inference)) {
            deprel = deprel_inference[0];
            return this.L + 1 + deprel;
        }
        System.err.printf("unknown transition in transform(Action): %d-%d", act.name(), act.rel());
        return -1;
    }

    Action transform(int act) {
        if (act == 0) {
            return ActionFactory.make_shift();
        }
        if (act < 1 + this.L) {
            return ActionFactory.make_left_arc(act - 1);
        }
        if (act < 1 + 2 * this.L) {
            return ActionFactory.make_right_arc(act - 1 - this.L);
        }
        System.err.printf("unknown transition in transform(int): %d", act);
        return new Action();
    }

    int number_of_transitions() {
        return this.L * 2 + 1;
    }
}

