/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.nnparser.action;

import com.hankcs.hanlp.dependency.nnparser.Dependency;
import com.hankcs.hanlp.dependency.nnparser.action.Action;
import com.hankcs.hanlp.dependency.nnparser.action.ActionFactory;
import com.hankcs.hanlp.dependency.nnparser.action.ActionType;
import java.util.ArrayList;
import java.util.List;

public class ActionUtils
implements ActionType {
    public static boolean is_shift(Action act) {
        return act.name() == 1;
    }

    public static boolean is_left_arc(Action act, int[] deprel) {
        if (act.name() == 2) {
            deprel[0] = act.rel();
            return true;
        }
        deprel[0] = 0;
        return false;
    }

    public static boolean is_right_arc(Action act, int[] deprel) {
        if (act.name() == 3) {
            deprel[0] = act.rel();
            return true;
        }
        deprel[0] = 0;
        return false;
    }

    void get_oracle_actions(List<Integer> heads, List<Integer> deprels, List<Action> actions) {
        int N = heads.size();
        int root = -1;
        ArrayList<List<Integer>> tree = new ArrayList<List<Integer>>(N);
        actions.clear();
        int i = 0;
        while (i < N) {
            int head = heads.get(i);
            if (head == -1) {
                if (root == -1) {
                    System.err.println("error: there should be only one root.");
                }
                root = i;
            } else {
                ((List)tree.get(head)).add(i);
            }
            ++i;
        }
        this.get_oracle_actions_travel(root, heads, deprels, tree, actions);
    }

    void get_oracle_actions_travel(int root, List<Integer> heads, List<Integer> deprels, List<List<Integer>> tree, List<Action> actions) {
        int child;
        List<Integer> children = tree.get(root);
        int i = 0;
        while (i < children.size() && children.get(i) < root) {
            this.get_oracle_actions_travel(children.get(i), heads, deprels, tree, actions);
            ++i;
        }
        actions.add(ActionFactory.make_shift());
        int j = i;
        while (j < children.size()) {
            child = children.get(j);
            this.get_oracle_actions_travel(child, heads, deprels, tree, actions);
            actions.add(ActionFactory.make_right_arc(deprels.get(child)));
            ++j;
        }
        j = i - 1;
        while (j >= 0) {
            child = children.get(j);
            actions.add(ActionFactory.make_left_arc(deprels.get(child)));
            --j;
        }
    }

    void get_oracle_actions2(Dependency instance, List<Action> actions) {
        this.get_oracle_actions2(instance.heads, instance.deprels, actions);
    }

    void get_oracle_actions2(List<Integer> heads, List<Integer> deprels, List<Action> actions) {
        actions.clear();
        int len = heads.size();
        ArrayList<Integer> sigma = new ArrayList<Integer>();
        int beta = 0;
        ArrayList<Integer> output = new ArrayList<Integer>(len);
        int i = 0;
        while (i < len) {
            output.add(-1);
            ++i;
        }
        boolean step = false;
        while (sigma.size() != 1 || beta != len) {
            int[] beta_reference = new int[]{beta};
            this.get_oracle_actions_onestep(heads, deprels, sigma, beta_reference, output, actions);
            beta = beta_reference[0];
        }
    }

    void get_oracle_actions_onestep(List<Integer> heads, List<Integer> deprels, List<Integer> sigma, int[] beta, List<Integer> output, List<Action> actions) {
        int top0 = sigma.size() > 0 ? sigma.get(sigma.size() - 1) : -1;
        int top1 = sigma.size() > 1 ? sigma.get(sigma.size() - 2) : -1;
        boolean all_descendents_reduced = true;
        if (top0 >= 0) {
            int i = 0;
            while (i < heads.size()) {
                if (heads.get(i) == top0 && output.get(i) != top0) {
                    all_descendents_reduced = false;
                    break;
                }
                ++i;
            }
        }
        if (top1 >= 0 && heads.get(top1) == top0) {
            actions.add(ActionFactory.make_left_arc(deprels.get(top1)));
            output.set(top1, top0);
            sigma.remove(sigma.size() - 1);
            sigma.set(sigma.size() - 1, top0);
        } else if (top1 >= 0 && heads.get(top0) == top1 && all_descendents_reduced) {
            actions.add(ActionFactory.make_right_arc(deprels.get(top0)));
            output.set(top0, top1);
            sigma.remove(sigma.size() - 1);
        } else if (beta[0] < heads.size()) {
            actions.add(ActionFactory.make_shift());
            sigma.add(beta[0]);
            beta[0] = beta[0] + 1;
        }
    }
}

