/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.utility.LexiconUtility;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeMap;

public class CoreDictionary {
    public static DoubleArrayTrie<Attribute> trie = new DoubleArrayTrie();
    public static final String path = HanLP.Config.CoreDictionaryPath;
    public static final int totalFrequency = 221894;
    public static final int NR_WORD_ID;
    public static final int NS_WORD_ID;
    public static final int NT_WORD_ID;
    public static final int T_WORD_ID;
    public static final int X_WORD_ID;
    public static final int M_WORD_ID;
    public static final int NX_WORD_ID;

    static {
        long start = System.currentTimeMillis();
        if (!CoreDictionary.load(path)) {
            Predefine.logger.severe("\u6838\u5fc3\u8bcd\u5178" + path + "\u52a0\u8f7d\u5931\u8d25");
            System.exit(-1);
        } else {
            Predefine.logger.info(String.valueOf(path) + "\u52a0\u8f7d\u6210\u529f\uff0c" + trie.size() + "\u4e2a\u8bcd\u6761\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        }
        NR_WORD_ID = CoreDictionary.getWordID("\u672a##\u4eba");
        NS_WORD_ID = CoreDictionary.getWordID("\u672a##\u5730");
        NT_WORD_ID = CoreDictionary.getWordID("\u672a##\u56e2");
        T_WORD_ID = CoreDictionary.getWordID("\u672a##\u65f6");
        X_WORD_ID = CoreDictionary.getWordID("\u672a##\u4e32");
        M_WORD_ID = CoreDictionary.getWordID("\u672a##\u6570");
        NX_WORD_ID = CoreDictionary.getWordID("\u672a##\u4e13");
    }

    private static boolean load(String path) {
        Predefine.logger.info("\u6838\u5fc3\u8bcd\u5178\u5f00\u59cb\u52a0\u8f7d:" + path);
        if (CoreDictionary.loadDat(path)) {
            return true;
        }
        TreeMap<String, Attribute> map = new TreeMap<String, Attribute>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            int MAX_FREQUENCY = 0;
            long start = System.currentTimeMillis();
            while ((line = br.readLine()) != null) {
                String[] param = line.split("\\s");
                int natureCount = (param.length - 1) / 2;
                Attribute attribute = new Attribute(natureCount);
                int i = 0;
                while (i < natureCount) {
                    attribute.nature[i] = Enum.valueOf(Nature.class, param[1 + 2 * i]);
                    attribute.frequency[i] = Integer.parseInt(param[2 + 2 * i]);
                    attribute.totalFrequency += attribute.frequency[i];
                    ++i;
                }
                map.put(param[0], attribute);
                MAX_FREQUENCY += attribute.totalFrequency;
            }
            Predefine.logger.info("\u6838\u5fc3\u8bcd\u5178\u8bfb\u5165\u8bcd\u6761" + map.size() + " \u5168\u90e8\u9891\u6b21" + MAX_FREQUENCY + "\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
            br.close();
            trie.build(map);
            Predefine.logger.info("\u6838\u5fc3\u8bcd\u5178\u52a0\u8f7d\u6210\u529f:" + trie.size() + "\u4e2a\u8bcd\u6761\uff0c\u4e0b\u9762\u5c06\u5199\u5165\u7f13\u5b58\u2026\u2026");
            try {
                DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(String.valueOf(path) + ".bin"));
                Collection attributeList = map.values();
                out.writeInt(attributeList.size());
                for (Attribute attribute : attributeList) {
                    out.writeInt(attribute.totalFrequency);
                    out.writeInt(attribute.nature.length);
                    int i = 0;
                    while (i < attribute.nature.length) {
                        out.writeInt(attribute.nature[i].ordinal());
                        out.writeInt(attribute.frequency[i]);
                        ++i;
                    }
                }
                trie.save(out);
                out.close();
            }
            catch (Exception e) {
                Predefine.logger.warning("\u4fdd\u5b58\u5931\u8d25" + e);
                return false;
            }
        }
        catch (FileNotFoundException e) {
            Predefine.logger.warning("\u6838\u5fc3\u8bcd\u5178" + path + "\u4e0d\u5b58\u5728\uff01" + e);
            return false;
        }
        catch (IOException e) {
            Predefine.logger.warning("\u6838\u5fc3\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        return true;
    }

    static boolean loadDat(String path) {
        ByteArray byteArray;
        block5: {
            byteArray = ByteArray.createByteArray(String.valueOf(path) + ".bin");
            if (byteArray != null) break block5;
            return false;
        }
        try {
            int size = byteArray.nextInt();
            Attribute[] attributes = new Attribute[size];
            Nature[] natureIndexArray = Nature.values();
            int i = 0;
            while (i < size) {
                int currentTotalFrequency = byteArray.nextInt();
                int length = byteArray.nextInt();
                attributes[i] = new Attribute(length);
                attributes[i].totalFrequency = currentTotalFrequency;
                int j = 0;
                while (j < length) {
                    attributes[i].nature[j] = natureIndexArray[byteArray.nextInt()];
                    attributes[i].frequency[j] = byteArray.nextInt();
                    ++j;
                }
                ++i;
            }
            return trie.load(byteArray, (Attribute[])attributes) && !byteArray.hasMore();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6\u5931\u8d25\uff0c\u95ee\u9898\u53d1\u751f\u5728" + e);
            return false;
        }
    }

    public static Attribute get(String key) {
        return trie.get(key);
    }

    public static Attribute get(int wordID) {
        return trie.get(wordID);
    }

    public static int getTermFrequency(String term) {
        Attribute attribute = CoreDictionary.get(term);
        if (attribute == null) {
            return 0;
        }
        return attribute.totalFrequency;
    }

    public static boolean contains(String key) {
        return trie.get(key) != null;
    }

    public static int getWordID(String a) {
        return trie.exactMatchSearch(a);
    }

    public static class Attribute
    implements Serializable {
        public Nature[] nature;
        public int[] frequency;
        public int totalFrequency;

        public Attribute(int size) {
            this.nature = new Nature[size];
            this.frequency = new int[size];
        }

        public Attribute(Nature[] nature, int[] frequency) {
            this.nature = nature;
            this.frequency = frequency;
        }

        public Attribute(Nature nature, int frequency) {
            this(1);
            this.nature[0] = nature;
            this.frequency[0] = frequency;
            this.totalFrequency = frequency;
        }

        public Attribute(Nature[] nature, int[] frequency, int totalFrequency) {
            this.nature = nature;
            this.frequency = frequency;
            this.totalFrequency = totalFrequency;
        }

        public Attribute(Nature nature) {
            this(nature, 1000);
        }

        public static Attribute create(String natureWithFrequency) {
            try {
                String[] param = natureWithFrequency.split(" ");
                int natureCount = param.length / 2;
                Attribute attribute = new Attribute(natureCount);
                int i = 0;
                while (i < natureCount) {
                    attribute.nature[i] = LexiconUtility.convertStringToNature(param[2 * i], null);
                    attribute.frequency[i] = Integer.parseInt(param[1 + 2 * i]);
                    attribute.totalFrequency += attribute.frequency[i];
                    ++i;
                }
                return attribute;
            }
            catch (Exception e) {
                Predefine.logger.warning("\u4f7f\u7528\u5b57\u7b26\u4e32" + natureWithFrequency + "\u521b\u5efa\u8bcd\u6761\u5c5e\u6027\u5931\u8d25\uff01" + TextUtility.exceptionToString(e));
                return null;
            }
        }

        public static Attribute create(ByteArray byteArray, Nature[] natureIndexArray) {
            int currentTotalFrequency = byteArray.nextInt();
            int length = byteArray.nextInt();
            Attribute attribute = new Attribute(length);
            attribute.totalFrequency = currentTotalFrequency;
            int j = 0;
            while (j < length) {
                attribute.nature[j] = natureIndexArray[byteArray.nextInt()];
                attribute.frequency[j] = byteArray.nextInt();
                ++j;
            }
            return attribute;
        }

        public int getNatureFrequency(String nature) {
            try {
                Nature pos = Enum.valueOf(Nature.class, nature);
                return this.getNatureFrequency(pos);
            }
            catch (IllegalArgumentException e) {
                return 0;
            }
        }

        public int getNatureFrequency(Nature nature) {
            int i = 0;
            Nature[] natureArray = this.nature;
            int n = this.nature.length;
            int n2 = 0;
            while (n2 < n) {
                Nature pos = natureArray[n2];
                if (nature == pos) {
                    return this.frequency[i];
                }
                ++i;
                ++n2;
            }
            return 0;
        }

        public boolean hasNature(Nature nature) {
            return this.getNatureFrequency(nature) > 0;
        }

        public boolean hasNatureStartsWith(String prefix) {
            Nature[] natureArray = this.nature;
            int n = this.nature.length;
            int n2 = 0;
            while (n2 < n) {
                Nature n3 = natureArray[n2];
                if (n3.startsWith(prefix)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.nature.length) {
                sb.append((Object)this.nature[i]).append(' ').append(this.frequency[i]).append(' ');
                ++i;
            }
            return sb.toString();
        }

        public void save(DataOutputStream out) throws IOException {
            out.writeInt(this.totalFrequency);
            out.writeInt(this.nature.length);
            int i = 0;
            while (i < this.nature.length) {
                out.writeInt(this.nature[i].ordinal());
                out.writeInt(this.frequency[i]);
                ++i;
            }
        }
    }
}

